/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.OcflObjectUpdater;
import edu.wisc.library.ocfl.api.OcflOption;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.FileChangeType;
import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.InvalidContentException;
import org.fcrepo.storage.ocfl.NotFoundException;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOcflObjectSession
implements OcflObjectSession {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOcflObjectSession.class);
    private static final int SPLITERATOR_OPTS = 17729;
    private final String sessionId;
    private final MutableOcflRepository ocflRepo;
    private final String ocflObjectId;
    private final Path objectStaging;
    private final ObjectReader headerReader;
    private final ObjectWriter headerWriter;
    private final Cache<String, ResourceHeaders> headersCache;
    private final DigestAlgorithm digestAlgorithm;
    private final OcflOption[] ocflOptions;
    private final VersionInfo versionInfo;
    private final Set<PathPair> deletePaths;
    private final Map<PathPair, String> digests;
    private final Map<String, ResourceHeaders> stagedHeaders;
    private CommitType commitType;
    private String rootResourceId;
    private boolean isArchivalGroup;
    private boolean closed = false;
    private boolean deleteObject = false;

    public DefaultOcflObjectSession(String sessionId, MutableOcflRepository ocflRepo, String ocflObjectId, Path objectStaging, ObjectReader headerReader, ObjectWriter headerWriter, CommitType commitType, Cache<String, ResourceHeaders> headersCache) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId cannot be null");
        this.ocflRepo = Objects.requireNonNull(ocflRepo, "ocflRepo cannot be null");
        this.ocflObjectId = Objects.requireNonNull(ocflObjectId, "ocflObjectId cannot be null");
        this.objectStaging = Objects.requireNonNull(objectStaging, "objectStaging cannot be null");
        this.headerReader = Objects.requireNonNull(headerReader, "headerReader cannot be null");
        this.headerWriter = Objects.requireNonNull(headerWriter, "headerWriter cannot be null");
        this.commitType = Objects.requireNonNull(commitType, "commitType cannot be null");
        this.headersCache = Objects.requireNonNull(headersCache, "headersCache cannot be null");
        this.versionInfo = new VersionInfo();
        this.deletePaths = new HashSet<PathPair>();
        this.digests = new HashMap<PathPair, String>();
        this.stagedHeaders = new HashMap<String, ResourceHeaders>();
        this.ocflOptions = new OcflOption[]{OcflOption.MOVE_SOURCE, OcflOption.OVERWRITE};
        this.loadRootResourceId();
        this.digestAlgorithm = this.identifyObjectDigestAlgorithm();
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public String ocflObjectId() {
        return this.ocflObjectId;
    }

    @Override
    public synchronized ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        PathPair contentPath = this.encode(paths.getContentFilePath());
        PathPair headerPath = this.encode(paths.getHeaderFilePath());
        Path contentDst = null;
        Path headerDst = this.createStagingPath(headerPath);
        this.deletePaths.remove(contentPath);
        this.deletePaths.remove(headerPath);
        try {
            ResourceHeaders.Builder headersBuilder = ResourceHeaders.builder(headers);
            if (content != null) {
                contentDst = this.createStagingPath(contentPath);
                String digest = this.getOcflDigest(headers.getDigests());
                if (digest == null) {
                    MessageDigest messageDigest = this.digestAlgorithm.getMessageDigest();
                    this.write(new DigestInputStream(content, messageDigest), contentDst);
                    digest = Hex.encodeHexString((byte[])messageDigest.digest());
                    headersBuilder.addDigest(this.digestUri(digest));
                } else {
                    this.write(content, contentDst);
                }
                this.digests.put(contentPath, digest);
                long fileSize = this.fileSize(contentDst);
                if (headers.getContentSize() != -1L && fileSize != headers.getContentSize()) {
                    throw new InvalidContentException(String.format("Resource %s's file size does not match expectation. Expected: %s; Actual: %s", headers.getId(), headers.getContentSize(), fileSize));
                }
                headersBuilder.withContentPath(contentPath.path).withContentSize(fileSize);
            }
            ResourceHeaders finalHeaders = headersBuilder.build();
            this.writeHeaders(finalHeaders, headerDst);
            this.touchRelatedResources(finalHeaders);
            return finalHeaders;
        }
        catch (RuntimeException e) {
            this.safeDelete(contentDst);
            this.safeDelete(headerDst);
            throw e;
        }
    }

    @Override
    public synchronized void writeHeaders(ResourceHeaders headers) {
        this.enforceOpen();
        PersistencePaths paths = this.resolvePersistencePaths(headers);
        PathPair headerPath = this.encode(paths.getHeaderFilePath());
        Path headerDst = this.createStagingPath(headerPath);
        this.deletePaths.remove(headerPath);
        this.writeHeaders(headers, headerDst);
        this.touchRelatedResources(headers);
    }

    @Override
    public synchronized void deleteContentFile(ResourceHeaders headers) {
        this.enforceOpen();
        String resourceId = headers.getId();
        PathPair headerPath = this.encode(PersistencePaths.headerPath(this.rootResourceId(), resourceId));
        if (this.newInSession(headerPath)) {
            this.deleteResource(resourceId);
        } else {
            ResourceHeaders existingHeaders = this.readHeaders(resourceId);
            if (existingHeaders.getContentPath() != null) {
                PathPair path = this.encode(existingHeaders.getContentPath());
                this.deletePaths.add(path);
                this.digests.remove(path);
            }
            ResourceHeaders finalHeaders = ResourceHeaders.builder(headers).withContentPath(null).withContentSize(-1L).withDigests(null).build();
            Path headerDst = this.createStagingPath(headerPath);
            this.writeHeaders(finalHeaders, headerDst);
            this.touchRelatedResources(finalHeaders);
        }
    }

    @Override
    public synchronized void deleteResource(String resourceId) {
        this.enforceOpen();
        if (Objects.equals(this.rootResourceId(), resourceId)) {
            this.deleteObject = true;
            this.deletePaths.clear();
            this.digests.clear();
            this.stagedHeaders.clear();
            if (Files.exists(this.objectStaging, new LinkOption[0])) {
                try {
                    FileUtils.deleteDirectory((File)this.objectStaging.toFile());
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to deleted staged files.", e);
                }
            }
        } else {
            PathPair headerPath = this.encode(PersistencePaths.headerPath(this.rootResourceId(), resourceId));
            ResourceHeaders existingHeaders = this.readHeaders(resourceId);
            this.deletePaths.add(headerPath);
            this.stagedHeaders.remove(existingHeaders.getId());
            if (existingHeaders.getContentPath() != null) {
                PathPair path = this.encode(existingHeaders.getContentPath());
                this.deletePaths.add(path);
                this.digests.remove(path);
            }
        }
    }

    @Override
    public boolean containsResource(String resourceId) {
        if (this.rootResourceId == null) {
            return false;
        }
        PathPair headerPath = this.encode(PersistencePaths.headerPath(this.rootResourceId(), resourceId));
        Optional<InputStream> stream = this.readStreamOptional(headerPath, null);
        if (stream.isPresent()) {
            try {
                stream.get().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId) {
        return this.readHeaders(resourceId, null);
    }

    @Override
    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        if (versionNumber == null && this.stagedHeaders.containsKey(resourceId)) {
            return this.stagedHeaders.get(resourceId);
        }
        PathPair headerPath = this.encode(PersistencePaths.headerPath(this.rootResourceId(), resourceId));
        if (this.isOpen() && this.deletePaths.contains(headerPath)) {
            throw this.notFoundException(headerPath, resourceId);
        }
        String resolvedVersionNum = this.resolveVersionNumber(resourceId, versionNumber);
        return this.headersCache.get(this.cacheKey(resourceId, resolvedVersionNum), key -> {
            LOG.trace("Cache miss for {}", key);
            InputStream headerStream = this.readFromOcfl(headerPath, resourceId, resolvedVersionNum);
            return this.parseHeaders(headerStream);
        });
    }

    @Override
    public ResourceContent readContent(String resourceId) {
        return this.readContent(resourceId, null);
    }

    @Override
    public ResourceContent readContent(String resourceId, String versionNumber) {
        ResourceHeaders headers = this.readHeaders(resourceId, versionNumber);
        Optional<InputStream> contentStream = Optional.empty();
        if (headers.getContentPath() != null) {
            contentStream = Optional.of(this.readStream(this.encode(headers.getContentPath()), resourceId, versionNumber));
        }
        return new ResourceContent(contentStream, headers);
    }

    @Override
    public List<OcflVersionInfo> listVersions(String resourceId) {
        String headerPath = PersistencePaths.headerPath(this.rootResourceId(), resourceId);
        if (!this.fileExistsInOcfl(headerPath)) {
            PathPair encoded = this.encode(headerPath);
            if (Files.exists(this.stagingPath(encoded), new LinkOption[0])) {
                return Collections.emptyList();
            }
            throw new NotFoundException(String.format("Resource %s was not found.", resourceId));
        }
        return this.listFileVersions(resourceId, headerPath);
    }

    @Override
    public Stream<ResourceHeaders> streamResourceHeaders() {
        HashSet<String> headerPaths = new HashSet<String>();
        headerPaths.addAll(this.listStagedHeaders());
        headerPaths.addAll(this.listCommittedHeaders());
        this.deletePaths.forEach(path -> headerPaths.remove(path.path));
        final Iterator it = headerPaths.iterator();
        return StreamSupport.stream(Spliterators.spliterator(new Iterator<ResourceHeaders>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public ResourceHeaders next() {
                String next = (String)it.next();
                return DefaultOcflObjectSession.this.parseHeaders(DefaultOcflObjectSession.this.readStreamOptional(DefaultOcflObjectSession.this.encode(next), null).orElseThrow(() -> new IllegalStateException("Unable to find resource header file " + next)));
            }
        }, (long)headerPaths.size(), 17729), false);
    }

    @Override
    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.versionInfo.setCreated(timestamp);
    }

    @Override
    public void versionAuthor(String name, String address) {
        this.versionInfo.setUser(name, address);
    }

    @Override
    public void versionMessage(String message) {
        this.versionInfo.setMessage(message);
    }

    @Override
    public void commitType(CommitType commitType) {
        this.commitType = Objects.requireNonNull(commitType, "commitType cannot be null");
    }

    @Override
    public synchronized void commit() {
        this.enforceOpen();
        this.closed = true;
        if (this.deleteObject) {
            this.ocflRepo.purgeObject(this.ocflObjectId);
        }
        boolean hasMutableHead = this.ocflRepo.hasStagedChanges(this.ocflObjectId);
        String newVersionNum = null;
        if (!this.deletePaths.isEmpty() || Files.exists(this.objectStaging, new LinkOption[0])) {
            this.deletePathsFromStaging();
            Consumer<OcflObjectUpdater> updater = this.createObjectUpdater();
            newVersionNum = this.commitType == CommitType.UNVERSIONED || this.hasMutableHeadAndShouldCreateNewVersion(hasMutableHead) ? this.ocflRepo.stageChanges(ObjectVersionId.head((String)this.ocflObjectId), this.versionInfo, updater).getVersionNum().toString() : this.ocflRepo.updateObject(ObjectVersionId.head((String)this.ocflObjectId), this.versionInfo, updater).getVersionNum().toString();
        }
        if (this.hasMutableHeadAndShouldCreateNewVersion(hasMutableHead)) {
            this.ocflRepo.commitStagedChanges(this.ocflObjectId, this.versionInfo);
        }
        if (newVersionNum != null) {
            this.moveStagedHeadersToCache(newVersionNum);
        }
        this.cleanup();
    }

    @Override
    public synchronized void abort() {
        if (!this.closed) {
            this.closed = true;
            this.cleanup();
        }
    }

    @Override
    public void close() {
        this.abort();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    private PersistencePaths resolvePersistencePaths(ResourceHeaders headers) {
        PersistencePaths paths;
        String resourceId = headers.getId();
        if (InteractionModel.ACL.getUri().equals(headers.getInteractionModel())) {
            ResourceHeaders parentHeaders = this.readHeaders(headers.getParent());
            paths = PersistencePaths.aclResource(!InteractionModel.NON_RDF.getUri().equals(parentHeaders.getInteractionModel()), this.resolveRootResourceId(headers), resourceId);
        } else if (InteractionModel.NON_RDF.getUri().equals(headers.getInteractionModel())) {
            paths = PersistencePaths.nonRdfResource(this.resolveRootResourceId(headers), resourceId);
        } else if (headers.getInteractionModel() != null) {
            paths = PersistencePaths.rdfResource(this.resolveRootResourceId(headers), resourceId);
        } else {
            throw new IllegalArgumentException(String.format("Interaction model for resource %s must be populated.", resourceId));
        }
        return paths;
    }

    private InputStream readStream(PathPair path, String resourceId, String versionNumber) {
        return this.readStreamOptional(path, versionNumber).orElseThrow(() -> this.notFoundException(path, resourceId));
    }

    private InputStream readFromOcfl(PathPair path, String resourceId, String versionNumber) {
        return this.readFromOcflOptional(path, versionNumber).orElseThrow(() -> this.notFoundException(path, resourceId));
    }

    private Optional<InputStream> readStreamOptional(PathPair path, String versionNumber) {
        if (this.isOpen() && this.deletePaths.contains(path)) {
            return Optional.empty();
        }
        if (versionNumber != null) {
            return this.readFromOcflOptional(path, versionNumber);
        }
        return this.readFromStaging(path).or(() -> this.readFromOcflOptional(path, versionNumber));
    }

    private Optional<InputStream> readFromStaging(PathPair path) {
        Path stagingPath = this.stagingPath(path);
        if (Files.exists(stagingPath, new LinkOption[0])) {
            try {
                return Optional.of(Files.newInputStream(stagingPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Optional.empty();
    }

    private Optional<InputStream> readFromOcflOptional(PathPair path, String versionNumber) {
        try {
            OcflObjectVersion object;
            if ((!this.deleteObject || !this.isOpen()) && this.containsOcflObject() && (object = this.ocflRepo.getObject(ObjectVersionId.version((String)this.ocflObjectId, (String)versionNumber))).containsFile(path.path)) {
                return Optional.of(object.getFile(path.path).getStream());
            }
        }
        catch (edu.wisc.library.ocfl.api.exception.NotFoundException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Path stagingPath(PathPair path) {
        return this.objectStaging.resolve(path.encodedPath);
    }

    private Path createStagingPath(PathPair path) {
        Path stagingPath = this.stagingPath(path);
        try {
            Files.createDirectories(stagingPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stagingPath;
    }

    private void write(InputStream content, Path destination) {
        try {
            Files.copy(content, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeHeaders(ResourceHeaders headers, Path destination) {
        try {
            this.headerWriter.writeValue(destination.toFile(), (Object)headers);
            this.stagedHeaders.put(headers.getId(), headers);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void touchRelatedResources(ResourceHeaders headers) {
        if (this.isArchivalGroup && !Objects.equals(this.rootResourceId(), headers.getId()) && !InteractionModel.ACL.getUri().equals(headers.getInteractionModel())) {
            LOG.debug("Touching AG {} after updating {}", (Object)this.rootResourceId(), (Object)headers.getId());
            this.touchResource(this.rootResourceId(), headers.getLastModifiedDate(), headers.getStateToken());
        }
        if (InteractionModel.NON_RDF_DESCRIPTION.getUri().equals(headers.getInteractionModel())) {
            LOG.debug("Touching binary {} after updating {}", (Object)headers.getParent(), (Object)headers.getId());
            this.touchResource(headers.getParent(), headers.getLastModifiedDate(), headers.getStateToken());
        } else if (InteractionModel.NON_RDF.getUri().equals(headers.getInteractionModel())) {
            String descriptionId = headers.getId() + "/fcr:metadata";
            LOG.debug("Touching binary description {} after updating {}", (Object)descriptionId, (Object)headers.getId());
            try {
                this.touchResource(descriptionId, headers.getLastModifiedDate(), headers.getStateToken());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private void touchResource(String resourceId, Instant timestamp, String stateToken) {
        ResourceHeaders headers = ResourceHeaders.builder(this.readHeaders(resourceId)).withLastModifiedDate(timestamp).withStateToken(stateToken).build();
        PathPair headerPath = this.encode(PersistencePaths.headerPath(this.rootResourceId(), resourceId));
        Path headerDst = this.createStagingPath(headerPath);
        this.writeHeaders(headers, headerDst);
    }

    private Consumer<OcflObjectUpdater> createObjectUpdater() {
        return updater -> {
            if (Files.exists(this.objectStaging, new LinkOption[0])) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    this.addDecodedPaths((OcflObjectUpdater)updater, this.ocflOptions);
                } else {
                    updater.addPath(this.objectStaging, this.ocflOptions);
                }
            }
            this.digests.forEach((path, digest) -> updater.addFileFixity(path.path, this.digestAlgorithm, digest));
            this.deletePaths.forEach(path -> updater.removeFile(path.path));
        };
    }

    private void deletePathsFromStaging() {
        this.deletePaths.stream().map(this::stagingPath).forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private ResourceHeaders parseHeaders(InputStream stream) {
        try {
            return (ResourceHeaders)this.headerReader.readValue(stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<OcflVersionInfo> listFileVersions(String resourceId, String headerPath) {
        VersionDetails headDesc = this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId));
        return this.ocflRepo.fileChangeHistory(this.ocflObjectId, headerPath).getFileChanges().stream().filter(change -> change.getChangeType() == FileChangeType.UPDATE).filter(change -> !headDesc.isMutable() || !headDesc.getVersionNum().equals((Object)change.getVersionNum())).map(change -> new OcflVersionInfo(resourceId, this.ocflObjectId, change.getVersionNum().toString(), this.toMementoInstant(change.getTimestamp()))).collect(Collectors.toList());
    }

    private boolean fileExistsInOcfl(String path) {
        if (this.containsOcflObject()) {
            return this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId)).containsFile(path);
        }
        return false;
    }

    private boolean newInSession(PathPair headerPath) {
        if (this.containsOcflObject()) {
            return !this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId)).containsFile(headerPath.path);
        }
        return true;
    }

    private void loadRootResourceId() {
        if (this.containsOcflObject()) {
            Optional<InputStream> stream = this.readFromOcflOptional(this.encode(".fcrepo/fcr-root.json"), null);
            if (stream.isPresent()) {
                ResourceHeaders headers = this.parseHeaders(stream.get());
                this.rootResourceId = headers.getId();
                this.isArchivalGroup = headers.isArchivalGroup();
                VersionDetails headVersion = this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId));
                this.addToCache(this.rootResourceId, headVersion.getVersionNum().toString(), headers);
            } else {
                throw new IllegalStateException(String.format("OCFL object %s exists but it does not contain a root Fedora resource", this.ocflObjectId));
            }
        }
    }

    private String resolveRootResourceId(ResourceHeaders headers) {
        if (this.rootResourceId == null) {
            this.rootResourceId = headers.getId();
            this.isArchivalGroup = headers.isArchivalGroup();
        }
        return this.rootResourceId;
    }

    private String rootResourceId() {
        if (this.rootResourceId != null) {
            return this.rootResourceId;
        }
        throw new NotFoundException("No resource found in object " + this.ocflObjectId);
    }

    private PathPair encode(String value) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String encoded = value.contains("/") ? Arrays.stream(value.split("/")).map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8)).collect(Collectors.joining("/")) : URLEncoder.encode(value, StandardCharsets.UTF_8);
            return new PathPair(value, encoded);
        }
        return new PathPair(value, value);
    }

    private void addDecodedPaths(OcflObjectUpdater updater, OcflOption ... ocflOptions) {
        try (Stream<Path> paths = Files.walk(this.objectStaging, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String logicalPath = this.stagingPathToLogicalPath((Path)file);
                updater.addPath(file, logicalPath, ocflOptions);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String stagingPathToLogicalPath(Path path) {
        String relative = this.objectStaging.relativize(path).toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            return URLDecoder.decode(relative.replace("\\", "/"), StandardCharsets.UTF_8);
        }
        return relative;
    }

    private Set<String> listStagedHeaders() {
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            Set<String> set;
            block9: {
                Stream<Path> paths = Files.walk(this.objectStaging, new FileVisitOption[0]);
                try {
                    set = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::stagingPathToLogicalPath).filter(PersistencePaths::isHeaderFile).collect(Collectors.toSet());
                    if (paths == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                paths.close();
            }
            return set;
        }
        return Collections.emptySet();
    }

    private Set<String> listCommittedHeaders() {
        if (!(this.isOpen() && this.deleteObject || !this.containsOcflObject())) {
            return this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId)).getFiles().stream().map(FileDetails::getPath).filter(PersistencePaths::isHeaderFile).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private String resolveVersionNumber(String resourceId, String versionNumber) {
        if (versionNumber == null) {
            if (this.containsOcflObject()) {
                VersionDetails headVersion = this.ocflRepo.describeVersion(ObjectVersionId.head((String)this.ocflObjectId));
                return headVersion.getVersionNum().toString();
            }
            throw new NotFoundException(String.format("Resource %s was not found.", resourceId));
        }
        return versionNumber;
    }

    private void cleanup() {
        if (Files.exists(this.objectStaging, new LinkOption[0])) {
            FileUtils.deleteQuietly((File)this.objectStaging.toFile());
        }
    }

    private void enforceOpen() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Session %s is already closed!", this.sessionId));
        }
    }

    private Instant toMementoInstant(OffsetDateTime timestamp) {
        return timestamp.toInstant().truncatedTo(ChronoUnit.SECONDS);
    }

    private long fileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getOcflDigest(Collection<URI> headerDigests) {
        if (headerDigests != null) {
            for (URI uri : headerDigests) {
                String[] parts = uri.getSchemeSpecificPart().split(":");
                if (parts.length != 2 || !this.digestAlgorithm.getJavaStandardName().equalsIgnoreCase(parts[0])) continue;
                return parts[1];
            }
        }
        return null;
    }

    private URI digestUri(String digest) {
        try {
            return new URI("urn", this.digestAlgorithm.getJavaStandardName() + ":" + digest, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private DigestAlgorithm identifyObjectDigestAlgorithm() {
        if (this.containsOcflObject()) {
            return this.ocflRepo.describeObject(this.ocflObjectId).getDigestAlgorithm();
        }
        return this.ocflRepo.config().getDefaultDigestAlgorithm();
    }

    private boolean hasMutableHeadAndShouldCreateNewVersion(boolean hasMutableHead) {
        return this.commitType == CommitType.NEW_VERSION && hasMutableHead;
    }

    private void safeDelete(Path path) {
        if (path != null) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                LOG.error("Failed to delete staged file: {}", (Object)path);
            }
        }
    }

    private boolean containsOcflObject() {
        return this.ocflRepo.containsObject(this.ocflObjectId);
    }

    private void moveStagedHeadersToCache(String newVersionNum) {
        this.stagedHeaders.forEach((id, headers) -> this.addToCache((String)id, newVersionNum, (ResourceHeaders)headers));
        this.stagedHeaders.clear();
    }

    private void addToCache(String resourceId, String versionNumber, ResourceHeaders headers) {
        String key = this.cacheKey(resourceId, versionNumber);
        LOG.trace("Adding to cache {}", (Object)key);
        this.headersCache.put(key, headers);
    }

    private String cacheKey(String id, String versionNum) {
        return String.format("%s_%s", id, versionNum);
    }

    private NotFoundException notFoundException(PathPair path, String resourceId) {
        return new NotFoundException(String.format("File %s was not found for resource %s", path.path, resourceId));
    }

    private static class PathPair {
        final String path;
        final String encodedPath;

        PathPair(String path, String encodedPath) {
            this.path = path;
            this.encodedPath = encodedPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathPair pathPair = (PathPair)o;
            return this.path.equals(pathPair.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }
}

