/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.generator.dublincore;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.generator.dublincore.DCGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertiesGenerator
implements DCGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertiesGenerator.class);
    protected static final String[] SALIENT_DC_PROPERTY_NAMESPACES = new String[]{"dc:*"};

    @Override
    public InputStream getStream(Node node) {
        StringBuilder str = new StringBuilder();
        str.append("<oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n");
        try {
            PropertyIterator iter = node.getProperties(SALIENT_DC_PROPERTY_NAMESPACES);
            while (iter.hasNext()) {
                Property property = iter.nextProperty();
                if (property.isMultiple()) {
                    for (Value v : property.getValues()) {
                        str.append("\t<" + property.getName() + ">" + v.getString() + "</" + property.getName() + ">\n");
                    }
                    continue;
                }
                str.append("\t<" + property.getName() + ">" + property.getValue().getString() + "</" + property.getName() + ">\n");
            }
            str.append("</oai_dc:dc>");
            return new ByteArrayInputStream(str.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (RepositoryException e) {
            LOGGER.error("Repository exception: {}", (Throwable)e);
            return null;
        }
    }
}

