/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.fcrepo.config.BasePropsConfig;
import org.fcrepo.config.DigestAlgorithm;
import org.fcrepo.config.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OcflPropsConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcflPropsConfig.class);
    public static final String FCREPO_OCFL_STAGING = "fcrepo.ocfl.staging";
    public static final String FCREPO_OCFL_ROOT = "fcrepo.ocfl.root";
    public static final String FCREPO_OCFL_TEMP = "fcrepo.ocfl.temp";
    private static final String FCREPO_OCFL_S3_BUCKET = "fcrepo.ocfl.s3.bucket";
    private static final String OCFL_STAGING = "staging";
    private static final String OCFL_ROOT = "ocfl-root";
    private static final String OCFL_TEMP = "ocfl-temp";
    private static final String FCREPO_PERSISTENCE_ALGORITHM = "fcrepo.persistence.defaultDigestAlgorithm";
    @Value(value="${fcrepo.ocfl.staging:#{fedoraPropsConfig.fedoraData.resolve('staging')}}")
    private Path fedoraOcflStaging;
    @Value(value="${fcrepo.ocfl.root:#{fedoraPropsConfig.fedoraData.resolve('ocfl-root')}}")
    private Path ocflRepoRoot;
    @Value(value="${fcrepo.ocfl.temp:#{fedoraPropsConfig.fedoraData.resolve('ocfl-temp')}}")
    private Path ocflTemp;
    @Value(value="${fcrepo.autoversioning.enabled:true}")
    private boolean autoVersioningEnabled;
    @Value(value="${fcrepo.storage:ocfl-fs}")
    private String storageStr;
    private Storage storage;
    @Value(value="${fcrepo.aws.access-key:}")
    private String awsAccessKey;
    @Value(value="${fcrepo.aws.secret-key:}")
    private String awsSecretKey;
    @Value(value="${fcrepo.aws.region:}")
    private String awsRegion;
    @Value(value="${fcrepo.ocfl.s3.bucket:}")
    private String ocflS3Bucket;
    @Value(value="${fcrepo.ocfl.s3.prefix:}")
    private String ocflS3Prefix;
    @Value(value="${fcrepo.resource-header-cache.enable:true}")
    private boolean resourceHeadersCacheEnabled;
    @Value(value="${fcrepo.resource-header-cache.max-size:512}")
    private long resourceHeadersCacheMaxSize;
    @Value(value="${fcrepo.resource-header-cache.expire-after-seconds:600}")
    private long resourceHeadersCacheExpireAfterSeconds;
    @Value(value="${fcrepo.ocfl.reindex.threads:-1}")
    private long reindexThreads;
    @Value(value="${fcrepo.ocfl.reindex.batchSize:100}")
    private long reindexBatchSize;
    @Value(value="${fcrepo.ocfl.reindex.failOnError:true}")
    private boolean reindexFailOnError;
    @Value(value="${fcrepo.persistence.defaultDigestAlgorithm:sha512}")
    private String FCREPO_DIGEST_ALGORITHM_VALUE;
    private DigestAlgorithm FCREPO_DIGEST_ALGORITHM;
    private static final List<DigestAlgorithm> FCREPO_VALID_DIGEST_ALGORITHMS = List.of(DigestAlgorithm.SHA256, DigestAlgorithm.SHA512);
    private static final long availableThreads = Runtime.getRuntime().availableProcessors();

    @PostConstruct
    private void postConstruct() throws IOException {
        this.reindexThreads = this.reindexThreads < 0L ? OcflPropsConfig.computeDefaultReindexThreads() : this.checkReindexThreadLimit(this.reindexThreads);
        this.storage = Storage.fromString(this.storageStr);
        LOGGER.info("Fedora storage type: {}", (Object)this.storage);
        LOGGER.info("Fedora staging: {}", (Object)this.fedoraOcflStaging);
        LOGGER.info("Fedora OCFL temp: {}", (Object)this.ocflTemp);
        LOGGER.info("Fedora OCFL reindexing threads: {}", (Object)this.reindexThreads);
        LOGGER.info("Fedora OCFL reindexing batch size: {}", (Object)this.reindexBatchSize);
        LOGGER.info("Fedora OCFL reindexing fail on error: {}", (Object)this.reindexFailOnError);
        Files.createDirectories(this.fedoraOcflStaging, new FileAttribute[0]);
        Files.createDirectories(this.ocflTemp, new FileAttribute[0]);
        if (this.storage == Storage.OCFL_FILESYSTEM) {
            LOGGER.info("Fedora OCFL root: {}", (Object)this.ocflRepoRoot);
            Files.createDirectories(this.ocflRepoRoot, new FileAttribute[0]);
        } else if (this.storage == Storage.OCFL_S3) {
            Objects.requireNonNull(this.ocflS3Bucket, String.format("The property %s must be set when OCFL S3 storage is used", FCREPO_OCFL_S3_BUCKET));
            LOGGER.info("Fedora AWS access key: {}", (Object)this.awsAccessKey);
            LOGGER.info("Fedora AWS secret key set: {}", (Object)Objects.isNull(this.awsSecretKey));
            LOGGER.info("Fedora AWS region: {}", (Object)this.awsRegion);
            LOGGER.info("Fedora OCFL S3 bucket: {}", (Object)this.ocflS3Bucket);
            LOGGER.info("Fedora OCFL S3 prefix: {}", (Object)this.ocflS3Prefix);
        }
        this.FCREPO_DIGEST_ALGORITHM = DigestAlgorithm.fromAlgorithm(this.FCREPO_DIGEST_ALGORITHM_VALUE);
        if (DigestAlgorithm.MISSING.equals((Object)this.FCREPO_DIGEST_ALGORITHM) || !FCREPO_VALID_DIGEST_ALGORITHMS.contains((Object)this.FCREPO_DIGEST_ALGORITHM)) {
            throw new IllegalArgumentException(String.format("Invalid %s property configured: %s, must be one of %s", FCREPO_PERSISTENCE_ALGORITHM, this.FCREPO_DIGEST_ALGORITHM_VALUE, FCREPO_VALID_DIGEST_ALGORITHMS.stream().map(DigestAlgorithm::getAlgorithm).collect(Collectors.joining(", "))));
        }
        LOGGER.info("Fedora OCFL digest algorithm: {}", (Object)this.FCREPO_DIGEST_ALGORITHM.getAlgorithm());
    }

    public Path getFedoraOcflStaging() {
        return this.fedoraOcflStaging;
    }

    public void setFedoraOcflStaging(Path fedoraOcflStaging) {
        this.fedoraOcflStaging = fedoraOcflStaging;
    }

    public Path getOcflRepoRoot() {
        return this.ocflRepoRoot;
    }

    public void setOcflRepoRoot(Path ocflRepoRoot) {
        this.ocflRepoRoot = ocflRepoRoot;
    }

    public Path getOcflTemp() {
        return this.ocflTemp;
    }

    public void setOcflTemp(Path ocflTemp) {
        this.ocflTemp = ocflTemp;
    }

    public boolean isAutoVersioningEnabled() {
        return this.autoVersioningEnabled;
    }

    public void setAutoVersioningEnabled(boolean autoVersioningEnabled) {
        this.autoVersioningEnabled = autoVersioningEnabled;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getOcflS3Bucket() {
        return this.ocflS3Bucket;
    }

    public void setOcflS3Bucket(String ocflS3Bucket) {
        this.ocflS3Bucket = ocflS3Bucket;
    }

    public String getOcflS3Prefix() {
        return this.ocflS3Prefix;
    }

    public void setOcflS3Prefix(String ocflS3Prefix) {
        this.ocflS3Prefix = ocflS3Prefix;
    }

    public boolean isResourceHeadersCacheEnabled() {
        return this.resourceHeadersCacheEnabled;
    }

    public void setResourceHeadersCacheEnabled(boolean resourceHeadersCacheEnabled) {
        this.resourceHeadersCacheEnabled = resourceHeadersCacheEnabled;
    }

    public long getResourceHeadersCacheMaxSize() {
        return this.resourceHeadersCacheMaxSize;
    }

    public void setResourceHeadersCacheMaxSize(long resourceHeadersCacheMaxSize) {
        this.resourceHeadersCacheMaxSize = resourceHeadersCacheMaxSize;
    }

    public long getResourceHeadersCacheExpireAfterSeconds() {
        return this.resourceHeadersCacheExpireAfterSeconds;
    }

    public void setResourceHeadersCacheExpireAfterSeconds(long resourceHeadersCacheExpireAfterSeconds) {
        this.resourceHeadersCacheExpireAfterSeconds = resourceHeadersCacheExpireAfterSeconds;
    }

    public void setReindexingThreads(long threads) {
        this.reindexThreads = this.checkReindexThreadLimit(threads);
    }

    public long getReindexingThreads() {
        return this.reindexThreads;
    }

    public long getReindexBatchSize() {
        return this.reindexBatchSize;
    }

    public void setReindexBatchSize(long reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
    }

    public boolean isReindexFailOnError() {
        return this.reindexFailOnError;
    }

    public void setReindexFailOnError(boolean reindexFailOnError) {
        this.reindexFailOnError = reindexFailOnError;
    }

    private long checkReindexThreadLimit(long threads) {
        if (threads <= 0L) {
            LOGGER.warn("Can't have fewer than 1 reindexing thread, setting to 1.");
            return 1L;
        }
        return threads;
    }

    private static long computeDefaultReindexThreads() {
        return availableThreads - 1L;
    }

    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.FCREPO_DIGEST_ALGORITHM;
    }
}

