/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import org.fcrepo.config.BasePropsConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricsConfig
extends BasePropsConfig {
    @Value(value="${fcrepo.metrics.enable:false}")
    private boolean metricsEnabled;

    @Bean
    public MeterRegistry meterRegistry() {
        SimpleMeterRegistry registry;
        if (this.metricsEnabled) {
            registry = new PrometheusMeterRegistry(new PrometheusConfig(){

                public Duration step() {
                    return Duration.ofSeconds(30L);
                }

                public String get(String key) {
                    return null;
                }
            });
            registry.config().meterFilter(new MeterFilter(){

                public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                    if (id.getType() == Meter.Type.TIMER) {
                        return DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(true)).percentiles(new double[]{0.5, 0.9, 0.99}).build().merge(config);
                    }
                    return config;
                }
            });
            new JvmThreadMetrics().bindTo((MeterRegistry)registry);
            new JvmGcMetrics().bindTo((MeterRegistry)registry);
            new JvmMemoryMetrics().bindTo((MeterRegistry)registry);
            new ProcessorMetrics().bindTo((MeterRegistry)registry);
            new UptimeMetrics().bindTo((MeterRegistry)registry);
        } else {
            registry = new SimpleMeterRegistry();
        }
        Metrics.addRegistry((MeterRegistry)registry);
        return registry;
    }

    @Bean
    public CollectorRegistry collectorRegistry(MeterRegistry meterRegistry) {
        if (meterRegistry instanceof PrometheusMeterRegistry) {
            return ((PrometheusMeterRegistry)meterRegistry).getPrometheusRegistry();
        }
        return CollectorRegistry.defaultRegistry;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }
}

