/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.FactoryBean;

public class FlywayFactory
implements FactoryBean<Flyway> {
    private DataSource dataSource;
    private String databaseType;

    public static FlywayFactory create() {
        return new FlywayFactory();
    }

    public Flyway getObject() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalStateException("Cannot get flyway instance without a configured datasource.");
        }
        Flyway fly = Flyway.configure().dataSource(this.dataSource).locations(new String[]{"classpath:sql/" + (this.databaseType == null ? "h2" : this.databaseType)}).load();
        fly.migrate();
        return fly;
    }

    public Class<?> getObjectType() {
        return Flyway.class;
    }

    public FlywayFactory setDataSource(DataSource source) {
        this.dataSource = source;
        return this;
    }

    public FlywayFactory setDatabaseType(String type) {
        this.databaseType = type;
        return this;
    }
}

