/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.fcrepo.config.BasePropsConfig;
import org.fcrepo.config.JmsDestination;
import org.fcrepo.config.ServerManagedPropsMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class FedoraPropsConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraPropsConfig.class);
    public static final String FCREPO_JMS_HOST = "fcrepo.jms.host";
    public static final String FCREPO_DYNAMIC_JMS_PORT = "fcrepo.dynamic.jms.port";
    public static final String FCREPO_DYNAMIC_STOMP_PORT = "fcrepo.dynamic.stomp.port";
    public static final String FCREPO_ACTIVEMQ_CONFIGURATION = "fcrepo.activemq.configuration";
    public static final String FCREPO_NAMESPACE_REGISTRY = "fcrepo.namespace.registry";
    public static final String FCREPO_EXTERNAL_CONTENT_ALLOWED = "fcrepo.external.content.allowed";
    private static final String FCREPO_ACTIVEMQ_DIRECTORY = "fcrepo.activemq.directory";
    private static final String FCREPO_SESSION_TIMEOUT = "fcrepo.session.timeout";
    private static final String FCREPO_VELOCITY_RUNTIME_LOG = "fcrepo.velocity.runtime.log";
    private static final String FCREPO_REBUILD_VALIDATION_FIXITY = "fcrepo.rebuild.validation.fixity";
    private static final String FCREPO_REBUILD_ON_START = "fcrepo.rebuild.on.start";
    private static final String FCREPO_JMS_BASEURL = "fcrepo.jms.baseUrl";
    private static final String FCREPO_SERVER_MANAGED_PROPS_MODE = "fcrepo.properties.management";
    private static final String FCREPO_JMS_DESTINATION_TYPE = "fcrepo.jms.destination.type";
    private static final String FCREPO_JMS_DESTINATION_NAME = "fcrepo.jms.destination.name";
    public static final String FCREPO_JMS_ENABLED = "fcrepo.jms.enabled";
    private static final String DATA_DIR_DEFAULT_VALUE = "data";
    private static final String LOG_DIR_DEFAULT_VALUE = "logs";
    private static final String ACTIVE_MQ_DIR_DEFAULT_VALUE = "ActiveMQ/kahadb";
    @Value(value="${fcrepo.home:fcrepo-home}")
    protected Path fedoraHome;
    @Value(value="#{fedoraPropsConfig.fedoraHome.resolve('data')}")
    private Path fedoraData;
    @Value(value="#{fedoraPropsConfig.fedoraHome.resolve('logs')}")
    private Path fedoraLogs;
    @Value(value="${fcrepo.jms.host:localhost}")
    private String jmsHost;
    @Value(value="${fcrepo.dynamic.jms.port:61616}")
    private String jmsPort;
    @Value(value="${fcrepo.dynamic.stomp.port:61613}")
    private String stompPort;
    @Value(value="${fcrepo.activemq.configuration:classpath:/config/activemq.xml}")
    private Resource activeMQConfiguration;
    @Value(value="${fcrepo.activemq.directory:#{fedoraPropsConfig.fedoraData.resolve('ActiveMQ/kahadb').toAbsolutePath().toString()}}")
    private String activeMqDirectory;
    @Value(value="${fcrepo.namespace.registry:classpath:/namespaces.yml}")
    private String namespaceRegistry;
    @Value(value="${fcrepo.external.content.allowed:#{null}}")
    private String externalContentAllowed;
    @Value(value="${fcrepo.session.timeout:180000}")
    private Long sessionTimeoutLong;
    private Duration sessionTimeout;
    @Value(value="${fcrepo.velocity.runtime.log:#{fedoraPropsConfig.fedoraLogs.resolve('velocity.log').toString()}}")
    private Path velocityLog;
    @Value(value="${fcrepo.rebuild.validation.fixity:false}")
    private boolean rebuildFixityCheck;
    @Value(value="${fcrepo.rebuild.on.start:false}")
    private boolean rebuildOnStart;
    @Value(value="${fcrepo.jms.baseUrl:#{null}}")
    private String jmsBaseUrl;
    @Value(value="${fcrepo.properties.management:strict}")
    private String serverManagedPropsModeStr;
    private ServerManagedPropsMode serverManagedPropsMode;
    @Value(value="${fcrepo.jms.destination.type:topic}")
    private String jmsDestinationTypeStr;
    private JmsDestination jmsDestinationType;
    @Value(value="${fcrepo.jms.destination.name:fedora}")
    private String jmsDestinationName;

    @PostConstruct
    private void postConstruct() throws IOException {
        LOGGER.info("Fedora home: {}", (Object)this.fedoraHome);
        LOGGER.debug("Fedora home data: {}", (Object)this.fedoraData);
        try {
            Files.createDirectories(this.fedoraHome, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to create Fedora home directory at %s. Fedora home can be configured by setting the %s property.", this.fedoraHome, "fcrepo.home"), e);
        }
        Files.createDirectories(this.fedoraData, new FileAttribute[0]);
        this.serverManagedPropsMode = ServerManagedPropsMode.fromString(this.serverManagedPropsModeStr);
        this.sessionTimeout = Duration.ofMillis(this.sessionTimeoutLong);
        this.jmsDestinationType = JmsDestination.fromString(this.jmsDestinationTypeStr);
    }

    public Path getFedoraHome() {
        return this.fedoraHome;
    }

    public void setFedoraHome(Path fedoraHome) {
        this.fedoraHome = fedoraHome;
    }

    public Path getFedoraData() {
        return this.fedoraData;
    }

    public Path getFedoraLogs() {
        return this.fedoraLogs;
    }

    public void setFedoraData(Path fedoraData) {
        this.fedoraData = fedoraData;
    }

    public String getJmsHost() {
        return this.jmsHost;
    }

    public String getJmsPort() {
        return this.jmsPort;
    }

    public String getStompPort() {
        return this.stompPort;
    }

    public String getActiveMqDirectory() {
        return this.activeMqDirectory;
    }

    public Resource getActiveMQConfiguration() {
        return this.activeMQConfiguration;
    }

    public String getExternalContentAllowed() {
        return this.externalContentAllowed;
    }

    public String getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Path getVelocityLog() {
        return this.velocityLog;
    }

    public boolean isRebuildFixityCheck() {
        return this.rebuildFixityCheck;
    }

    public boolean isRebuildOnStart() {
        return this.rebuildOnStart;
    }

    public void setRebuildOnStart(boolean rebuildOnStart) {
        this.rebuildOnStart = rebuildOnStart;
    }

    public String getJmsBaseUrl() {
        return this.jmsBaseUrl;
    }

    public ServerManagedPropsMode getServerManagedPropsMode() {
        return this.serverManagedPropsMode;
    }

    public void setServerManagedPropsMode(ServerManagedPropsMode serverManagedPropsMode) {
        this.serverManagedPropsMode = serverManagedPropsMode;
    }

    public JmsDestination getJmsDestinationType() {
        return this.jmsDestinationType;
    }

    public String getJmsDestinationName() {
        return this.jmsDestinationName;
    }
}

