/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DigestAlgorithm {
    SHA1("SHA", "urn:sha1", "sha-1", "sha1"),
    SHA256("SHA-256", "urn:sha-256", "sha256"),
    SHA512("SHA-512", "urn:sha-512", "sha512"),
    SHA512256("SHA-512/256", "urn:sha-512/256", "sha512/256"),
    MD5("MD5", "urn:md5", new String[0]),
    MISSING("NONE", "missing", new String[0]);

    private final String algorithm;
    private final String scheme;
    private final Set<String> aliases;

    private DigestAlgorithm(String alg, String scheme, String ... aliases) {
        this.algorithm = alg;
        this.scheme = scheme;
        this.aliases = Stream.concat(Arrays.stream(aliases), Stream.of(this.algorithm)).map(String::valueOf).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public static String getScheme(String alg) {
        return Arrays.stream(DigestAlgorithm.values()).filter((Predicate<DigestAlgorithm>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getScheme$0(java.lang.String org.fcrepo.config.DigestAlgorithm ), (Lorg/fcrepo/config/DigestAlgorithm;)Z)((String)alg)).findFirst().orElse((DigestAlgorithm)DigestAlgorithm.MISSING).scheme;
    }

    public static DigestAlgorithm fromScheme(String argScheme) {
        return Arrays.stream(DigestAlgorithm.values()).filter(value -> value.scheme.equalsIgnoreCase(argScheme)).findFirst().orElse(MISSING);
    }

    public static DigestAlgorithm fromAlgorithm(String alg) {
        String seek = alg.toLowerCase();
        return Arrays.stream(DigestAlgorithm.values()).filter(value -> value.aliases.contains(seek)).findFirst().orElse(MISSING);
    }

    public static boolean isSupportedAlgorithm(String alg) {
        return !DigestAlgorithm.getScheme(alg).equals(DigestAlgorithm.MISSING.scheme);
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    private static /* synthetic */ boolean lambda$getScheme$0(String alg, DigestAlgorithm value) {
        return value.algorithm.equalsIgnoreCase(alg) || value.algorithm.replace("-", "").equalsIgnoreCase(alg);
    }
}

