/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.fcrepo.config.BasePropsConfig;
import org.fcrepo.config.FlywayFactory;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@Configuration
public class DatabaseConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseConfig.class);
    private static final String H2_FILE = "fcrepo-h2";
    @Value(value="${fcrepo.db.url:#{'jdbc:h2:' + fedoraPropsConfig.fedoraData.resolve('fcrepo-h2').toAbsolutePath().toString() + ';FILE_LOCK=SOCKET'}}")
    private String dbUrl;
    @Value(value="${fcrepo.db.user:}")
    private String dbUser;
    @Value(value="${fcrepo.db.password:}")
    private String dbPassword;
    @Value(value="${fcrepo.db.max.pool.size:15}")
    private Integer maxPoolSize;
    @Value(value="${fcrepo.db.connection.checkout.timeout:10000}")
    private Integer checkoutTimeout;
    @Value(value="${fcrepo.db.connection.idle.test.period:300}")
    private Integer idleConnectionTestPeriod;
    @Value(value="${fcrepo.db.connection.test.on.checkout:true}")
    private boolean testConnectionOnCheckout;
    private static final Map<String, String> DB_DRIVER_MAP = Map.of("h2", "org.h2.Driver", "postgresql", "org.postgresql.Driver", "mariadb", "org.mariadb.jdbc.Driver", "mysql", "com.mysql.cj.jdbc.Driver");

    @PostConstruct
    public void setup() {
        ((ConverterRegistry)DefaultConversionService.getSharedInstance()).addConverter((Converter)new Converter<LocalDateTime, Instant>(){

            public Instant convert(LocalDateTime source) {
                return source.toInstant(ZoneOffset.UTC);
            }
        });
    }

    @Bean
    public DataSource dataSource() throws Exception {
        String driver = this.identifyDbDriver();
        LOGGER.debug("JDBC URL: {}", (Object)this.dbUrl);
        LOGGER.debug("Using database driver: {}", (Object)driver);
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        dataSource.setDriverClass(driver);
        dataSource.setJdbcUrl(this.dbUrl);
        dataSource.setUser(this.dbUser);
        dataSource.setPassword(this.dbPassword);
        dataSource.setCheckoutTimeout(this.checkoutTimeout.intValue());
        dataSource.setMaxPoolSize(this.maxPoolSize.intValue());
        dataSource.setIdleConnectionTestPeriod(this.idleConnectionTestPeriod.intValue());
        dataSource.setTestConnectionOnCheckout(this.testConnectionOnCheckout);
        this.flyway((DataSource)dataSource);
        return dataSource;
    }

    private String getDbType() {
        String[] parts = this.dbUrl.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid DB url: " + this.dbUrl);
        }
        return parts[1].toLowerCase();
    }

    private String identifyDbDriver() {
        String driver = DB_DRIVER_MAP.get(this.getDbType());
        if (driver == null) {
            throw new IllegalStateException("No database driver found for: " + this.dbUrl);
        }
        return driver;
    }

    @Bean
    public DataSourceTransactionManager txManager(DataSource dataSource) {
        DataSourceTransactionManager txManager = new DataSourceTransactionManager();
        txManager.setDataSource(dataSource);
        return txManager;
    }

    @Bean
    public Flyway flyway(DataSource source) throws Exception {
        LOGGER.debug("Instantiating a new flyway bean");
        return FlywayFactory.create().setDataSource(source).setDatabaseType(this.getDbType()).getObject();
    }
}

