/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.config;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

public abstract class ConditionOnProperty<T>
implements ConfigurationCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionOnProperty.class);
    private final String name;
    private final T expected;
    private final T defaultValue;
    private final Class<T> clazz;

    public ConditionOnProperty(String name, T expected, T defaultValue, Class<T> clazz) {
        this.name = name;
        this.expected = expected;
        this.defaultValue = defaultValue;
        this.clazz = clazz;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        LOGGER.debug("Prop {}: {}", (Object)this.name, (Object)context.getEnvironment().getProperty(this.name));
        return Objects.equals(this.expected, context.getEnvironment().getProperty(this.name, this.clazz, this.defaultValue));
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }
}

