/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.webac;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.auth.webac.ACLHandle;
import org.fcrepo.auth.webac.WebACAuthorization;
import org.fcrepo.http.api.FedoraAcl;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.identifiers.IdentifierConverter;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.TimeMap;
import org.fcrepo.kernel.api.models.WebacAcl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebACRolesProvider {
    public static final String GROUP_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.groupAgent.baseUri";
    public static final String USER_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.userAgent.baseUri";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebACRolesProvider.class);
    private static final Node RDF_TYPE_NODE = NodeFactory.createURI((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final Node VCARD_GROUP_NODE = NodeFactory.createURI((String)"http://www.w3.org/2006/vcard/ns#Group");
    private static final Node VCARD_MEMBER_NODE = NodeFactory.createURI((String)"http://www.w3.org/2006/vcard/ns#hasMember");
    @Inject
    private ResourceFactory resourceFactory;
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessToClass = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToClassURIs().contains(uri));
    private static final Function<List<String>, Predicate<WebACAuthorization>> accessTo = uris -> auth -> uris.stream().anyMatch(uri -> auth.getAccessToURIs().contains(uri));
    private static final Predicate<Triple> hasAclPredicate = triple -> triple.getPredicate().getNameSpace().equals("http://www.w3.org/ns/auth/acl#");

    public Map<String, Collection<String>> getRoles(FedoraResource resource, Transaction transaction) {
        LOGGER.debug("Getting agent roles for: {}", (Object)resource.getPath());
        Optional<ACLHandle> effectiveAcl = WebACRolesProvider.getEffectiveAcl(resource, false);
        ArrayList<String> resourcePaths = new ArrayList<String>();
        if (resource instanceof WebacAcl) {
            resourcePaths.add(resource.getContainer().getId());
        } else {
            resourcePaths.add(resource.getDescribedResource().getId());
        }
        List rdfTypes = resource.getDescription().getTypes();
        effectiveAcl.map(aclHandle -> aclHandle.resource).filter(effectiveResource -> !effectiveResource.getId().equals(resource.getId())).ifPresent(effectiveResource -> {
            resourcePaths.add(effectiveResource.getId());
            rdfTypes.addAll(effectiveResource.getTypes());
        });
        if (!effectiveAcl.isPresent()) {
            resourcePaths.addAll(WebACRolesProvider.getAllPathAncestors(resource.getId()));
        }
        Predicate<WebACAuthorization> checkAccessTo = accessTo.apply(resourcePaths);
        Predicate<WebACAuthorization> checkAccessToClass = accessToClass.apply(rdfTypes.stream().map(URI::toString).collect(Collectors.toList()));
        List authorizations = effectiveAcl.map(auth -> auth.authorizations).orElseGet(() -> WebACRolesProvider.getDefaultAuthorizations());
        HashMap<String, Collection<String>> effectiveRoles = new HashMap<String, Collection<String>>();
        authorizations.stream().filter(checkAccessTo.or(checkAccessToClass)).forEach(auth -> {
            Stream.concat(auth.getAgents().stream(), this.dereferenceAgentGroups(transaction, auth.getAgentGroups()).stream()).filter(agent -> !agent.equals("http://xmlns.com/foaf/0.1/Agent") && !agent.equals("http://www.w3.org/ns/auth/acl#AuthenticatedAgent")).forEach(agent -> effectiveRoles.computeIfAbsent((String)agent, key -> new HashSet()).addAll(auth.getModes().stream().map(URI::toString).collect(Collectors.toSet())));
            auth.getAgentClasses().stream().filter(agentClass -> agentClass.equals("http://xmlns.com/foaf/0.1/Agent") || agentClass.equals("http://www.w3.org/ns/auth/acl#AuthenticatedAgent")).forEach(agentClass -> effectiveRoles.computeIfAbsent((String)agentClass, key -> new HashSet()).addAll(auth.getModes().stream().map(URI::toString).collect(Collectors.toSet())));
        });
        LOGGER.debug("Unfiltered ACL: {}", effectiveRoles);
        return effectiveRoles;
    }

    private static List<String> getAllPathAncestors(String path) {
        List<String> segments = Arrays.asList(path.replace("info:fedora", "").split("/"));
        return IntStream.range(1, segments.size()).mapToObj(frameSize -> {
            String subpath = String.join((CharSequence)"/", segments.subList(1, frameSize));
            return "info:fedora" + (!subpath.isBlank() ? "/" : "") + subpath;
        }).collect(Collectors.toList());
    }

    private List<String> dereferenceAgentGroups(Transaction transaction, Collection<String> agentGroups) {
        IdentifierConverter translator = null;
        List<String> members = agentGroups.stream().flatMap(agentGroup -> {
            if (agentGroup.startsWith("info:fedora")) {
                int hashIndex = agentGroup.indexOf("#");
                String agentGroupNoHash = hashIndex > 0 ? agentGroup.substring(0, hashIndex) : agentGroup;
                String hashedSuffix = hashIndex > 0 ? agentGroup.substring(hashIndex) : null;
                try {
                    FedoraId fedoraId = FedoraId.create((String[])new String[]{agentGroupNoHash});
                    FedoraResource resource = this.resourceFactory.getResource(transaction, fedoraId);
                    return WebACRolesProvider.getAgentMembers((IdentifierConverter<Resource, FedoraResource>)translator, resource, hashedSuffix);
                }
                catch (PathNotFoundException e) {
                    throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
            if (agentGroup.equals("http://xmlns.com/foaf/0.1/Agent")) {
                return Stream.of(agentGroup);
            }
            LOGGER.info("Ignoring agentGroup: {}", agentGroup);
            return Stream.empty();
        }).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled() && !agentGroups.isEmpty()) {
            LOGGER.debug("Found {} members in {} agentGroups resources", (Object)members.size(), (Object)agentGroups.size());
        }
        return members;
    }

    private static Stream<String> getAgentMembers(IdentifierConverter<Resource, FedoraResource> translator, FedoraResource resource, String hashPortion) {
        List triples = resource.getTriples().filter(triple -> hashPortion == null || triple.getSubject().getURI().endsWith(hashPortion)).collect(Collectors.toList());
        boolean hasVcardGroup = triples.stream().anyMatch(triple -> triple.matches(triple.getSubject(), RDF_TYPE_NODE, VCARD_GROUP_NODE));
        if (hasVcardGroup) {
            return triples.stream().filter(triple -> triple.predicateMatches(VCARD_MEMBER_NODE)).map(Triple::getObject).flatMap(WebACRolesProvider::nodeToStringStream).map(WebACRolesProvider::stripUserAgentBaseURI);
        }
        return Stream.empty();
    }

    private static String stripUserAgentBaseURI(String object) {
        String userBaseUri = System.getProperty(USER_AGENT_BASE_URI_PROPERTY);
        if (userBaseUri != null && object.startsWith(userBaseUri)) {
            return object.substring(userBaseUri.length());
        }
        return object;
    }

    private static Stream<String> nodeToStringStream(Node object) {
        if (object.isURI()) {
            return Stream.of(object.getURI());
        }
        if (object.isLiteral()) {
            return Stream.of(object.getLiteralValue().toString());
        }
        return Stream.empty();
    }

    private static List<WebACAuthorization> getAuthorizations(FedoraResource aclResource, boolean ancestorAcl) {
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        Object translator = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ACL: {}", (Object)aclResource.getPath());
        }
        if (aclResource.isAcl()) {
            List triples = (List)aclResource.getTriples().collect(Collectors.toList());
            Set authSubjects = triples.stream().filter(t -> t.getPredicate().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && t.getObject().getURI().equals("http://www.w3.org/ns/auth/acl#Authorization")).map(t -> t.getSubject()).collect(Collectors.toSet());
            HashMap authMap = new HashMap();
            triples.stream().filter(hasAclPredicate).forEach(triple -> {
                if (authSubjects.contains(triple.getSubject())) {
                    Map aclTriples = authMap.computeIfAbsent(triple.getSubject().getURI(), key -> new HashMap());
                    String predicate = triple.getPredicate().getURI();
                    List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                    WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                    if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                        WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                    }
                }
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding acl:Authorization from {}", (Object)aclResource.getPath());
            }
            authMap.values().forEach(aclTriples -> {
                WebACAuthorization authorization = WebACRolesProvider.createAuthorizationFromMap(aclTriples);
                if (!ancestorAcl || authorization.getDefaults().size() > 0) {
                    authorizations.add(authorization);
                }
            });
        }
        return authorizations;
    }

    private static WebACAuthorization createAuthorizationFromMap(Map<String, List<String>> data) {
        return new WebACAuthorization(data.getOrDefault("http://www.w3.org/ns/auth/acl#agent", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#agentClass", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#mode", Collections.emptyList()).stream().map(URI::create).collect(Collectors.toList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessTo", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#accessToClass", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#agentGroup", Collections.emptyList()), data.getOrDefault("http://www.w3.org/ns/auth/acl#default", Collections.emptyList()));
    }

    static Optional<ACLHandle> getEffectiveAcl(FedoraResource resource, boolean ancestorAcl) {
        try {
            FedoraResource described;
            List<WebACAuthorization> authorizations;
            FedoraResource aclResource = resource.getAcl();
            if (aclResource != null && (authorizations = WebACRolesProvider.getAuthorizations(aclResource, ancestorAcl)).size() > 0) {
                return Optional.of(new ACLHandle(resource, authorizations));
            }
            FedoraResource container = resource.getContainer();
            if (container == null && (resource instanceof NonRdfSourceDescription || resource instanceof TimeMap) && !Objects.equals(resource, described = resource.getDescribedResource())) {
                container = described;
            }
            if (container == null) {
                LOGGER.debug("No ACLs defined on this node or in parent hierarchy");
                return Optional.empty();
            }
            LOGGER.trace("Checking parent resource for ACL. No ACL found at {}", (Object)resource.getPath());
            return WebACRolesProvider.getEffectiveAcl(container, true);
        }
        catch (RepositoryException ex) {
            LOGGER.debug("Exception finding effective ACL: {}", (Object)ex.getMessage());
            return Optional.empty();
        }
    }

    private static List<WebACAuthorization> getDefaultAuthorizations() {
        HashMap<String, List<String>> aclTriples = new HashMap<String, List<String>>();
        ArrayList<WebACAuthorization> authorizations = new ArrayList<WebACAuthorization>();
        FedoraAcl.getDefaultAcl(null).listStatements().mapWith(FrontsTriple::asTriple).forEachRemaining(triple -> {
            if (hasAclPredicate.test((Triple)triple)) {
                String predicate = triple.getPredicate().getURI();
                List values = aclTriples.computeIfAbsent(predicate, key -> new ArrayList());
                WebACRolesProvider.nodeToStringStream(triple.getObject()).forEach(values::add);
                if (predicate.equals("http://www.w3.org/ns/auth/acl#agent")) {
                    WebACRolesProvider.additionalAgentValues(triple.getObject()).forEach(values::add);
                }
            }
        });
        authorizations.add(WebACRolesProvider.createAuthorizationFromMap(aclTriples));
        return authorizations;
    }

    private static Stream<String> additionalAgentValues(Node object) {
        String groupBaseUri = System.getProperty(GROUP_AGENT_BASE_URI_PROPERTY);
        String userBaseUri = System.getProperty(USER_AGENT_BASE_URI_PROPERTY);
        if (object.isURI()) {
            String uri = object.getURI();
            if (userBaseUri != null && uri.startsWith(userBaseUri)) {
                return Stream.of(uri.substring(userBaseUri.length()));
            }
            if (groupBaseUri != null && uri.startsWith(groupBaseUri)) {
                return Stream.of(uri.substring(groupBaseUri.length()));
            }
        }
        return Stream.empty();
    }
}

