/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.io.IOException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.fcrepo.auth.roles.common.AccessRoles;
import org.fcrepo.http.commons.session.SessionFactory;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessRolesTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessRolesTypes.class);
    @Autowired
    private final SessionFactory sessionFactory = null;

    @PostConstruct
    public void setUpRepositoryConfiguration() throws RepositoryException, IOException {
        this.registerNodeTypes(this.sessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNodeTypes(SessionFactory sessions) throws RepositoryException, IOException {
        Session session = null;
        try {
            session = sessions.getInternalSession();
            NodeTypeManager mgr = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
            URL cnd = AccessRoles.class.getResource("/cnd/access-control.cnd");
            NodeTypeIterator nti = mgr.registerNodeTypes(cnd, true);
            while (nti.hasNext()) {
                NodeType nt = nti.nextNodeType();
                LOGGER.debug("registered node type: {}", (Object)nt.getName());
            }
            session.save();
            LOGGER.debug("Registered access role node types");
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

