/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.auth.roles.common.AccessRoles;
import org.fcrepo.http.commons.api.rdf.UriAwareResourceModelFactory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.springframework.stereotype.Component;

@Component
public class AccessRolesResources
implements UriAwareResourceModelFactory {
    public Model createModelForResource(FedoraResource resource, UriInfo uriInfo, IdentifierTranslator graphSubjects) throws RepositoryException {
        Model model = ModelFactory.createDefaultModel();
        Resource s = graphSubjects.getSubject(resource.getNode().getPath());
        if (resource.getNode().isNodeType("fedora:resource")) {
            Map<String, String> pathMap = Collections.singletonMap("path", resource.getPath().substring(1));
            Resource acl = model.createResource(uriInfo.getBaseUriBuilder().path(AccessRoles.class).buildFromMap(pathMap).toASCIIString());
            model.add(s, RdfLexicon.HAS_ACCESS_ROLES_SERVICE, (RDFNode)acl);
        }
        return model;
    }
}

