/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.auth.roles.common.Constants;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccessRolesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessRolesProvider.class);
    public static final Map<String, List<String>> DEFAULT_ACCESS_ROLES = Collections.emptyMap();

    public Map<String, List<String>> getRoles(Node node, boolean effective) throws RepositoryException {
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        Session session = node.getSession();
        Constants.registerPrefixes(session);
        if (node.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())) {
            this.getAssignments(node, data);
            return data;
        }
        if (effective) {
            try {
                for (Node n = node.getParent(); n != null; n = n.getParent()) {
                    if (!n.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("effective roles are assigned at node: {}", (Object)n.getPath());
                    }
                    this.getAssignments(n, data);
                    if (LOGGER.isDebugEnabled()) {
                        for (Map.Entry entry : data.entrySet()) {
                            LOGGER.debug("{} has role(s) {}", entry.getKey(), entry.getValue());
                        }
                    }
                    return data;
                }
            }
            catch (ItemNotFoundException e) {
                LOGGER.trace("Subject not found, using default access roles", (Throwable)e);
                return DEFAULT_ACCESS_ROLES;
            }
        }
        return null;
    }

    private void getAssignments(Node node, Map<String, List<String>> data) throws RepositoryException {
        if (node.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())) {
            try {
                Node rbacl = node.getNode(Constants.JcrName.rbacl.getQualified());
                LOGGER.debug("got rbacl: {}", (Object)rbacl);
                NodeIterator ni = rbacl.getNodes();
                while (ni.hasNext()) {
                    Node assign = ni.nextNode();
                    String principalName = assign.getProperty(Constants.JcrName.principal.getQualified()).getString();
                    if (principalName == null || principalName.trim().length() == 0) {
                        LOGGER.warn("found empty principal name on node {}", (Object)node.getPath());
                        continue;
                    }
                    List<String> roles = data.get(principalName);
                    if (roles == null) {
                        roles = new ArrayList<String>();
                        data.put(principalName, roles);
                    }
                    for (Value v : assign.getProperty(Constants.JcrName.role.getQualified()).getValues()) {
                        if (v == null || v.toString().trim().length() == 0) {
                            LOGGER.warn("found empty role name on node {}", (Object)node.getPath());
                            continue;
                        }
                        roles.add(v.toString());
                    }
                }
            }
            catch (PathNotFoundException e) {
                LOGGER.info("Found rbaclAssignable mixin without a corresponding node at {}", (Object)node.getPath());
            }
        }
    }

    public void postRoles(Node node, Map<String, Set<String>> data) throws RepositoryException {
        Node acl;
        Session session = node.getSession();
        Constants.registerPrefixes(session);
        if (!node.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())) {
            node.addMixin(Constants.JcrName.rbaclAssignable.getQualified());
            LOGGER.debug("added rbaclAssignable type");
        }
        if (node.hasNode(Constants.JcrName.rbacl.getQualified())) {
            acl = node.getNode(Constants.JcrName.rbacl.getQualified());
            NodeIterator ni = acl.getNodes();
            while (ni.hasNext()) {
                ni.nextNode().remove();
            }
        } else {
            acl = node.addNode(Constants.JcrName.rbacl.getQualified(), Constants.JcrName.Rbacl.getQualified());
        }
        for (Map.Entry<String, Set<String>> entry : data.entrySet()) {
            Node assign = acl.addNode(Constants.JcrName.assignment.getQualified(), Constants.JcrName.Assignment.getQualified());
            assign.setProperty(Constants.JcrName.principal.getQualified(), entry.getKey());
            assign.setProperty(Constants.JcrName.role.getQualified(), (String[])Iterables.toArray((Iterable)entry.getValue(), String.class));
        }
    }

    public void deleteRoles(Node node) throws RepositoryException {
        Session session = node.getSession();
        Constants.registerPrefixes(session);
        if (node.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())) {
            try {
                Node rbacl = node.getNode(Constants.JcrName.rbacl.getQualified());
                rbacl.remove();
            }
            catch (PathNotFoundException e) {
                LOGGER.debug("Cannot find node: {}", (Object)node, (Object)e);
            }
            node.removeMixin(Constants.JcrName.rbaclAssignable.getQualified());
        }
    }

    public Map<String, List<String>> findRolesForPath(Path absPath, Session session) throws RepositoryException {
        Node node = null;
        for (Path p = absPath; p != null; p = p.getParent()) {
            try {
                if (p.isRoot()) {
                    node = session.getRootNode();
                    break;
                }
                node = session.getNode(p.getString());
                break;
            }
            catch (PathNotFoundException e) {
                LOGGER.debug("Cannot find node: {}", (Object)p, (Object)e);
                continue;
            }
        }
        return this.getRoles(node, true);
    }
}

