/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import com.codahale.metrics.annotation.Timed;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/{path: .*}/fcr:accessroles")
public class AccessRoles
extends AbstractResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessRoles.class);
    @InjectedSession
    protected Session session;
    @Autowired
    private AccessRolesProvider accessRolesProvider = null;
    @Context
    protected HttpServletRequest request;

    private AccessRolesProvider getAccessRolesProvider() {
        return this.accessRolesProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Timed
    public Response get(@PathParam(value="path") List<PathSegment> pathList, @QueryParam(value="effective") String effective) throws RepositoryException {
        Response.ResponseBuilder response;
        String path = AccessRoles.toPath(pathList);
        LOGGER.debug("Get access roles for: {}", (Object)path);
        LOGGER.debug("effective: {}", (Object)effective);
        try {
            Node node = this.nodeService.getObject(this.session, path).getNode();
            Map<String, List<String>> data = this.getAccessRolesProvider().getRoles(node, effective != null);
            if (data == null) {
                LOGGER.debug("no content response");
                response = Response.noContent();
            } else {
                response = Response.ok(data);
            }
        }
        finally {
            this.session.logout();
        }
        return response.build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response post(@PathParam(value="path") List<PathSegment> pathList, Map<String, Set<String>> data) throws RepositoryException {
        Response.ResponseBuilder response;
        String path = AccessRoles.toPath(pathList);
        LOGGER.debug("POST Received request param: {}", (Object)this.request);
        try {
            this.validatePOST(data);
            FedoraResource resource = this.nodeService.getObject(this.session, path);
            this.getAccessRolesProvider().postRoles(resource.getNode(), data);
            this.session.save();
            LOGGER.debug("Saved access roles {}", data);
            response = Response.created((URI)this.getUriInfo().getBaseUriBuilder().path(path).path("fcr:accessroles").build(new Object[0]));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        finally {
            this.session.logout();
        }
        return response.build();
    }

    private void validatePOST(Map<String, Set<String>> data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Posted access roles must include role assignments");
        }
        for (Map.Entry<String, Set<String>> entry : data.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().isEmpty()) {
                throw new IllegalArgumentException("Assignments must include principal name and one or more roles");
            }
            if (entry.getKey().trim().length() == 0) {
                throw new IllegalArgumentException("Principal names cannot be an empty strings or whitespace.");
            }
            for (String r : entry.getValue()) {
                if (r.trim().length() != 0) continue;
                throw new IllegalArgumentException("Role names cannot be an empty strings or whitespace.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Timed
    public Response deleteNodeType(@PathParam(value="path") List<PathSegment> pathList) throws RepositoryException {
        String path = AccessRoles.toPath(pathList);
        try {
            Node node = this.nodeService.getObject(this.session, path).getNode();
            this.getAccessRolesProvider().deleteRoles(node);
            this.session.save();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.session.logout();
        }
    }

    private UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

