/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.auth.common.FedoraAuthorizationDelegate;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRolesAuthorizationDelegate
implements FedoraAuthorizationDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRolesAuthorizationDelegate.class);
    protected static final String AUTHZ_DETECTION = "/{http://fedora.info/definitions/v4/authorization#}";
    private static final String[] REMOVE_ACTIONS = new String[]{"remove"};
    @Autowired
    private AccessRolesProvider accessRolesProvider = null;
    @Autowired
    private SessionFactory sessionFactory = null;

    public static Set<String> resolveUserRoles(Map<String, List<String>> acl, Set<Principal> principals) {
        HashSet<String> roles = new HashSet<String>();
        for (Principal p : principals) {
            List<String> matchedRoles = acl.get(p.getName());
            if (matchedRoles == null) continue;
            LOGGER.debug("request principal matched role assignment: {}", (Object)p.getName());
            roles.addAll(matchedRoles);
        }
        return roles;
    }

    public boolean hasPermission(Session session, Path absPath, String[] actions) {
        Set<String> roles;
        Principal userPrincipal = AbstractRolesAuthorizationDelegate.getUserPrincipal(session);
        if (userPrincipal == null) {
            return false;
        }
        Set<Principal> allPrincipals = AbstractRolesAuthorizationDelegate.getPrincipals(session);
        if (allPrincipals == null) {
            return false;
        }
        try {
            Session internalSession = this.sessionFactory.getInternalSession();
            Map<String, List<String>> acl = this.accessRolesProvider.findRolesForPath(absPath, internalSession);
            roles = AbstractRolesAuthorizationDelegate.resolveUserRoles(acl, allPrincipals);
            LOGGER.debug("roles for this request: {}", roles);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException("Cannot look up node information on " + absPath + " for permissions check.", (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}\t{}\t{}", new Object[]{roles, actions, absPath});
            if (actions.length > 1) {
                LOGGER.debug("FOUND MULTIPLE ACTIONS: {}", (Object)Arrays.toString(actions));
            }
        }
        if (actions.length == 1 && "remove_child_nodes".equals(actions[0])) {
            return true;
        }
        if (!this.rolesHavePermission(session, absPath.toString(), actions, roles)) {
            return false;
        }
        if (actions.length == 1 && "remove".equals(actions[0])) {
            return this.canRemoveChildrenRecursive(session, absPath.toString(), allPrincipals, roles);
        }
        return true;
    }

    private static Principal getUserPrincipal(Session session) {
        Object value = session.getAttribute("fedora-user-principal");
        if (value instanceof Principal) {
            return (Principal)value;
        }
        return null;
    }

    private static Set<Principal> getPrincipals(Session session) {
        Object value = session.getAttribute("fedora-all-principals");
        if (value instanceof Set) {
            return (Set)value;
        }
        return null;
    }

    private boolean canRemoveChildrenRecursive(Session userSession, String parentPath, Set<Principal> allPrincipals, Set<String> parentRoles) {
        try {
            Session internalSession = this.sessionFactory.getInternalSession();
            LOGGER.debug("Recursive child remove permission checks for: {}", (Object)parentPath);
            Node parent = internalSession.getNode(parentPath);
            if (!parent.hasNodes()) {
                return true;
            }
            NodeIterator ni = parent.getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                Map<String, List<String>> acl = null;
                try {
                    acl = this.accessRolesProvider.getRoles(n, false);
                }
                catch (PathNotFoundException ignored) {
                    LOGGER.trace("Path not found when removing roles", (Throwable)ignored);
                }
                Set<String> roles = acl != null ? AbstractRolesAuthorizationDelegate.resolveUserRoles(acl, allPrincipals) : parentRoles;
                if (this.rolesHavePermission(userSession, n.getPath(), REMOVE_ACTIONS, roles)) {
                    if (this.canRemoveChildrenRecursive(userSession, n.getPath(), allPrincipals, roles)) continue;
                    return false;
                }
                LOGGER.info("Remove permission denied at {} with roles {}", (Object)n.getPath(), roles);
                return false;
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException("Cannot lookup child permission check information for " + parentPath, (Throwable)e);
        }
    }

    public abstract boolean rolesHavePermission(Session var1, String var2, String[] var3, Set<String> var4);
}

