/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common.integration;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.http.client.ClientProtocolException;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.auth.roles.common.integration.AbstractCommonRolesIT;
import org.fcrepo.auth.roles.common.integration.RolesFadTestObjectBean;
import org.junit.Assert;
import org.junit.Test;

public class AccessRolesIT
extends AbstractCommonRolesIT {
    @Override
    protected List<RolesFadTestObjectBean> getTestObjs() {
        return test_objs;
    }

    @Test
    public void testGetEmptyRoles() throws ClientProtocolException, IOException {
        Assert.assertEquals((String)"Cannot get empty role list from object with no roles!", (long)Response.Status.NO_CONTENT.getStatusCode(), (long)this.canGetRoles(null, "testcommonobj1", false));
    }

    @Test
    public void testCRUDRoles() throws ClientProtocolException, IOException {
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)this.postRoles("testcommonobj1", this.test_json_roles));
        Assert.assertEquals((String)"Cannot get role list from object with roles!", (long)Response.Status.OK.getStatusCode(), (long)this.canGetRoles(null, "testcommonobj1", false));
        Assert.assertEquals((String)"Result does not equal test data!", (Object)t_roles, this.getRoles("testcommonobj1"));
        Assert.assertEquals((String)"Cannot delete role list from object with roles!", (long)Response.Status.NO_CONTENT.getStatusCode(), (long)this.canDeleteRoles(null, "testcommonobj1", false));
        Assert.assertEquals((String)"Cannot get empty role list from object with no roles!", (long)Response.Status.NO_CONTENT.getStatusCode(), (long)this.canGetRoles(null, "testcommonobj1", false));
    }

    @Test
    public void testGetEffectiveRoles() throws ClientProtocolException, IOException {
        Assert.assertEquals((String)"Cannot get effective role list from object!", (long)Response.Status.OK.getStatusCode(), (long)this.canGetEffectiveRoles(null, "testcommonobj1", false));
        Assert.assertEquals((String)"Result does not equal test data!", (Object)AccessRolesProvider.DEFAULT_ACCESS_ROLES, this.getEffectiveRoles("testcommonobj1"));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)this.postRoles("testcommonobj1", this.test_json_roles));
        Assert.assertEquals((String)"Cannot get effective role list from child object with inherited roles!", (long)Response.Status.OK.getStatusCode(), (long)this.canGetEffectiveRoles(null, "testcommonobj1/testchildobj1", false));
        Assert.assertEquals((String)"Result does not equal test data!", (Object)t_roles, this.getEffectiveRoles("testcommonobj1/testchildobj1"));
        Assert.assertEquals((String)"Cannot post admin ACL on child object!", (long)Response.Status.CREATED.getStatusCode(), (long)this.postRoles("testcommonobj1/testchildobj1", this.admin_json_role));
        Assert.assertEquals((String)"Cannot get effective role list from child object with own role!", (long)Response.Status.OK.getStatusCode(), (long)this.canGetEffectiveRoles(null, "testcommonobj1/testchildobj1", false));
        Assert.assertEquals((String)"Result does not equal test data!", (Object)admin_role, this.getEffectiveRoles("testcommonobj1/testchildobj1"));
    }

    @Test
    public void testInvalidAccessRoles() throws Exception {
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)this.postRoles("testcommonobj1", "invalid roles"));
    }

    @Test
    public void testInvalidMimeType() throws Exception {
        Assert.assertEquals((long)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (long)this.postRoles("testcommonobj1", this.test_json_roles, "text/plain"));
    }
}

