/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common.integration;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.fcrepo.auth.roles.common.integration.RolesFadTestObjectBean;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/spring-test/test-container.xml"})
public abstract class AbstractRolesIT {
    private static Logger logger = LoggerFactory.getLogger(AbstractRolesIT.class);
    protected static final int SERVER_PORT = Integer.parseInt(System.getProperty("test.port", "8080"));
    protected static final String HOSTNAME = "localhost";
    protected static final String SUFFIX = "fcr:accessroles";
    protected static final String serverAddress = "http://localhost:" + SERVER_PORT + "/rest/";
    protected final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    protected static CloseableHttpClient client;
    private static List<RolesFadTestObjectBean> test_objs;
    private static boolean is_setup;

    public AbstractRolesIT() {
        this.connectionManager.setMaxTotal(Integer.MAX_VALUE);
        this.connectionManager.setDefaultMaxPerRoute(20);
        this.connectionManager.closeIdleConnections(3L, TimeUnit.SECONDS);
        client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
    }

    @Before
    public void setUp() throws Exception {
        if (!is_setup) {
            test_objs = this.getTestObjs();
            for (RolesFadTestObjectBean obj : test_objs) {
                this.deleteTestObject(obj);
                this.ingestObject(obj);
            }
            is_setup = true;
            logger.info("SETUP SUCCESSFUL");
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        is_setup = false;
    }

    public int canRead(String username, String path, boolean is_authenticated) throws IOException {
        HttpGet method = this.getObjectMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canRead REST response status code [user: {}, path: {}]: {}", new Object[]{username, path, status});
        return status;
    }

    public int canDelete(String username, String path, boolean is_authenticated) throws IOException {
        HttpDelete method = this.deleteObjMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canDelete REST response status code [user: {}, path: {}]: {}", new Object[]{username, path, status});
        return status;
    }

    public int canAddDS(String username, String path, String dsName, boolean is_authenticated) throws IOException {
        HttpPost method = this.postDSMethod(path, dsName, "This is the datastream contents.");
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canAddDS REST response status code:  {}", (Object)status);
        return status;
    }

    public int canUpdateDS(String username, String path, String dsName, boolean is_authenticated) throws IOException {
        HttpPut method = this.putDSMethod(path, dsName, "This is my updated content.");
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canUpdateDS REST response status code:  {}", (Object)status);
        return status;
    }

    public int canAddACL(String username, String path, String principal, String role, boolean is_authenticated) throws IOException {
        HashMap<String, String> tmap = new HashMap<String, String>();
        tmap.put(principal, role);
        List<Map<String, String>> acls = Collections.singletonList(tmap);
        String jsonACLs = this.createJsonACLs(acls);
        HttpPost method = this.postRolesMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        method.addHeader("Content-Type", "application/json");
        StringEntity entity = new StringEntity(jsonACLs, "utf-8");
        method.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canAddACL REST response status code:  {}", (Object)status);
        return status;
    }

    public int canGetRoles(String username, String path, boolean is_authenticated) throws IOException {
        HttpGet method = this.getRolesMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canGetRoles REST response status code [user: {}, path: {}]: {}", new Object[]{username, path, status});
        return status;
    }

    public int canGetEffectiveRoles(String username, String path, boolean is_authenticated) throws IOException {
        HttpGet method = this.getEffectiveRolesMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canGetRoles REST response status code [user: {}, path: {}]: {}", new Object[]{username, path, status});
        return status;
    }

    public int canDeleteRoles(String username, String path, boolean is_authenticated) throws IOException {
        HttpDelete method = this.deleteRolesMethod(path);
        if (is_authenticated) {
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, username);
        }
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("canDeleteRoles REST response status code [user: {}, path: {}]: {}", new Object[]{username, path, status});
        return status;
    }

    protected HttpGet getRolesMethod(String param) {
        HttpGet get = new HttpGet(serverAddress + param + "/" + SUFFIX);
        logger.debug("GET: {}", (Object)get.getURI());
        return get;
    }

    protected HttpGet getEffectiveRolesMethod(String param) {
        HttpGet get = new HttpGet(serverAddress + param + "/" + SUFFIX + "?effective");
        logger.debug("GET: {}", (Object)get.getURI());
        return get;
    }

    protected HttpGet getObjectMethod(String param) {
        HttpGet get = new HttpGet(serverAddress + param);
        logger.debug("GET: {}", (Object)get.getURI());
        return get;
    }

    protected HttpPost postObjMethod(String param) {
        HttpPost post = new HttpPost(serverAddress + param);
        logger.debug("POST: {}", (Object)post.getURI());
        return post;
    }

    protected HttpPut putObjMethod(String param) {
        HttpPut put = new HttpPut(serverAddress + param);
        logger.debug("PUT: {}", (Object)put.getURI());
        return put;
    }

    protected HttpPut putDSMethod(String objectPath, String ds, String content) throws UnsupportedEncodingException {
        HttpPut put = new HttpPut(serverAddress + objectPath + "/" + ds + "/fcr:content");
        put.setEntity((HttpEntity)new StringEntity(content));
        logger.debug("PUT: {}", (Object)put.getURI());
        return put;
    }

    protected HttpPost postDSMethod(String objectPath, String ds, String content) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(serverAddress + objectPath + "/" + ds + "/fcr:content");
        post.setEntity((HttpEntity)new StringEntity(content));
        return post;
    }

    protected HttpPost postRolesMethod(String param) {
        HttpPost post = new HttpPost(serverAddress + param + "/" + SUFFIX);
        logger.debug("POST: {}", (Object)post.getURI());
        return post;
    }

    protected HttpDelete deleteObjMethod(String param) {
        HttpDelete delete = new HttpDelete(serverAddress + param);
        logger.debug("DELETE: {}", (Object)delete.getURI());
        return delete;
    }

    protected HttpDelete deleteRolesMethod(String param) {
        HttpDelete delete = new HttpDelete(serverAddress + param + "/" + SUFFIX);
        logger.debug("DELETE: {}", (Object)delete.getURI());
        return delete;
    }

    protected HttpResponse execute(HttpUriRequest method) throws IOException {
        logger.debug("Executing: " + method.getMethod() + " to " + method.getURI());
        return client.execute(method);
    }

    protected int getStatus(HttpUriRequest method) throws IOException {
        HttpResponse response = this.execute(method);
        int result = response.getStatusLine().getStatusCode();
        if (result <= 199 || result >= 400) {
            logger.warn(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return result;
    }

    protected int postRoles(String path, String json_roles) throws ParseException, IOException {
        return this.postRoles(path, json_roles, "application/json");
    }

    protected int postRoles(String path, String json_roles, String contentType) throws ParseException, IOException {
        HttpPost method = this.postRolesMethod(path);
        AbstractRolesIT.setAuth((AbstractHttpMessage)method, "fedoraAdmin");
        method.addHeader("Content-Type", contentType);
        StringEntity entity = new StringEntity(json_roles, "utf-8");
        method.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        Assert.assertNotNull((String)"There must be content for a post.", (Object)response.getEntity());
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        logger.debug("post response content: \n {}", (Object)content);
        return response.getStatusLine().getStatusCode();
    }

    protected Map<String, List<String>> getRoles(String path) throws ParseException, IOException {
        HttpGet method = this.getRolesMethod(path);
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("getRoles REST response status code [user: {}, path: {}]: {}", (Object)path, (Object)status);
        HttpEntity entity = response.getEntity();
        String content = EntityUtils.toString((HttpEntity)entity);
        logger.debug("content: {}", (Object)content);
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        return result;
    }

    protected Map<String, List<String>> getEffectiveRoles(String path) throws ParseException, IOException {
        HttpGet method = this.getEffectiveRolesMethod(path);
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        int status = response.getStatusLine().getStatusCode();
        logger.debug("getEffectiveRoles REST response status code [user: {}, path: {}]: {}", (Object)path, (Object)status);
        HttpEntity entity = response.getEntity();
        String content = EntityUtils.toString((HttpEntity)entity);
        logger.debug("content: {}", (Object)content);
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
        return result;
    }

    protected void deleteTestObject(RolesFadTestObjectBean obj) {
        try {
            HttpDelete method = this.deleteObjMethod(obj.getPath());
            AbstractRolesIT.setAuth((AbstractHttpMessage)method, "fedoraAdmin");
            client.execute((HttpUriRequest)method);
        }
        catch (Throwable ignored) {
            logger.debug("object {} doesn't exist -- not deleting", (Object)obj.getPath());
        }
    }

    protected void ingestObject(RolesFadTestObjectBean obj) throws Exception {
        HttpPut method = this.putObjMethod(obj.getPath());
        AbstractRolesIT.setAuth((AbstractHttpMessage)method, "fedoraAdmin");
        CloseableHttpResponse response = client.execute((HttpUriRequest)method);
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        int status = response.getStatusLine().getStatusCode();
        Assert.assertEquals((String)("Didn't get a CREATED response! Got content:\n" + content), (long)Response.Status.CREATED.getStatusCode(), (long)status);
        this.addObjectACLs(obj);
        this.addDatastreams(obj);
    }

    protected String makeJson(Map<String, List<String>> roles) {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, roles);
            return sw.toString();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static void setAuth(AbstractHttpMessage method, String username) {
        String creds = username + ":password";
        String encCreds = new String(Base64.encodeBase64((byte[])creds.getBytes()));
        String basic = "Basic " + encCreds;
        method.setHeader("Authorization", basic);
    }

    private void addObjectACLs(RolesFadTestObjectBean obj) throws Exception {
        if (obj.getACLs().size() > 0) {
            String jsonACLs = this.createJsonACLs(obj.getACLs());
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)this.postRoles(obj.getPath(), jsonACLs));
        }
    }

    private void addDatastreams(RolesFadTestObjectBean obj) throws Exception {
        for (Map<String, String> entries : obj.getDatastreams()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                String dsid = entry.getKey();
                HttpPost method = this.postDSMethod(obj.getPath(), dsid, entry.getValue());
                AbstractRolesIT.setAuth((AbstractHttpMessage)method, "fedoraAdmin");
                CloseableHttpResponse response = client.execute((HttpUriRequest)method);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                int status = response.getStatusLine().getStatusCode();
                Assert.assertEquals((String)("Didn't get a CREATED response! Got content:\n" + content), (long)Response.Status.CREATED.getStatusCode(), (long)status);
                this.addDatastreamACLs(obj, dsid);
            }
        }
    }

    private void addDatastreamACLs(RolesFadTestObjectBean obj, String dsid) throws Exception {
        if (obj.getDatastreamACLs(dsid) != null) {
            String jsonACLs = this.createJsonACLs(obj.getDatastreamACLs(dsid));
            logger.debug("addDatastreamACLs:  Datastream path: {}/{}", (Object)obj.getPath(), (Object)dsid);
            logger.debug("addDatastreamACLs:  JSON acls: {}{}", (Object)jsonACLs);
            Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)this.postRoles(obj.getPath() + "/" + dsid, jsonACLs));
        }
    }

    private String createJsonACLs(List<Map<String, String>> principals_and_roles) {
        HashMap<String, List<String>> acls = new HashMap<String, List<String>>();
        for (Map<String, String> entries : principals_and_roles) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                String key = entry.getKey();
                if (acls.containsKey(key)) {
                    ((List)acls.get(key)).add(entry.getValue());
                    continue;
                }
                acls.put(key, new ArrayList<String>(Arrays.asList(entry.getValue())));
            }
        }
        return this.makeJson(acls);
    }

    protected abstract List<RolesFadTestObjectBean> getTestObjs();

    static {
        is_setup = false;
    }
}

