/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.io.IOException;
import java.net.URL;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.fcrepo.auth.roles.common.AccessRolesTypes;
import org.fcrepo.http.commons.session.SessionFactory;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessRolesTypesTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessRolesTypesTest.class);
    @Mock
    private SessionFactory sessionFactory;
    @Mock
    private Workspace workspace;
    @Mock
    private Session session;
    private AccessRolesTypes accessRolesTypes;
    @Mock
    private NodeTypeManager nodeTypeManager;
    @Mock
    private NodeType mockNodeType;

    @Before
    public void setUp() throws RepositoryException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.workspace);
        Mockito.when((Object)this.workspace.getNodeTypeManager()).thenReturn((Object)this.nodeTypeManager);
        NodeTypeIterator mockNTI = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        Mockito.when((Object)mockNTI.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockNTI.nextNodeType()).thenReturn((Object)this.mockNodeType).thenThrow(new Throwable[]{new ArrayIndexOutOfBoundsException()});
        Mockito.when((Object)this.nodeTypeManager.registerNodeTypes((URL)Matchers.any(URL.class), Matchers.anyBoolean())).thenReturn((Object)mockNTI);
        this.accessRolesTypes = new AccessRolesTypes();
        TestHelpers.setField((Object)this.accessRolesTypes, (String)"sessionFactory", (Object)this.sessionFactory);
        Mockito.when((Object)this.sessionFactory.getInternalSession()).thenReturn((Object)this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryException.class)
    public void testSetupRepoConfigGetSessionException() throws RepositoryException, IOException {
        Mockito.when((Object)this.sessionFactory.getInternalSession()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            this.accessRolesTypes.setUpRepositoryConfiguration();
        }
        finally {
            ((NodeTypeManager)Mockito.verify((Object)this.nodeTypeManager, (VerificationMode)Mockito.never())).registerNodeTypes((URL)Matchers.any(URL.class), Matchers.anyBoolean());
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save();
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryException.class)
    public void testSetupRepoConfigGetNodeTypeManagerException() throws RepositoryException, IOException {
        Mockito.when((Object)this.workspace.getNodeTypeManager()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            this.accessRolesTypes.setUpRepositoryConfiguration();
        }
        finally {
            ((NodeTypeManager)Mockito.verify((Object)this.nodeTypeManager, (VerificationMode)Mockito.never())).registerNodeTypes((URL)Matchers.any(URL.class), Matchers.anyBoolean());
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save();
            ((Session)Mockito.verify((Object)this.session)).logout();
        }
    }

    @Test
    public void testSetupRepoConfig() throws RepositoryException, IOException {
        this.accessRolesTypes.setUpRepositoryConfiguration();
        ((NodeTypeManager)Mockito.verify((Object)this.nodeTypeManager)).registerNodeTypes((URL)Matchers.any(URL.class), Matchers.anyBoolean());
        ((Session)Mockito.verify((Object)this.session)).save();
        ((Session)Mockito.verify((Object)this.session)).logout();
    }
}

