/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.fcrepo.auth.roles.common.AccessRoles;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.services.NodeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AccessRolesTest {
    @Mock
    private AccessRolesProvider accessRolesProvider;
    @Mock
    private HttpServletRequest request;
    @Mock
    private NodeService nodeService;
    @Mock
    private FedoraResource fedoraResource;
    @Mock
    private Map<String, List<String>> rolesData;
    private List<PathSegment> paths;
    @Mock
    private PathSegment rootPath;
    private Session session;
    private AccessRoles accessRoles;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.accessRoles = new AccessRoles();
        TestHelpers.setField((Object)this.accessRoles, (String)"accessRolesProvider", (Object)this.accessRolesProvider);
        TestHelpers.setField((Object)this.accessRoles, (String)"request", (Object)this.request);
        TestHelpers.setField((Object)this.accessRoles, (String)"nodeService", (Object)this.nodeService);
        this.session = TestHelpers.mockSession((AbstractResource)this.accessRoles);
        TestHelpers.setField((Object)this.accessRoles, (String)"session", (Object)this.session);
        Mockito.when((Object)this.nodeService.getObject((Session)Matchers.any(Session.class), Matchers.anyString())).thenReturn((Object)this.fedoraResource);
        this.paths = new ArrayList<PathSegment>();
        Mockito.when((Object)this.rootPath.getPath()).thenReturn((Object)"");
        this.paths.add(this.rootPath);
    }

    @Test
    public void testGetNoData() throws RepositoryException {
        Mockito.when((Object)this.accessRolesProvider.getRoles((Node)Matchers.any(Node.class), Matchers.anyBoolean())).thenReturn(null);
        Response response = this.accessRoles.get(this.paths, null);
        Assert.assertEquals((String)"NoContent response expected when no data found", (long)Response.noContent().build().getStatus(), (long)response.getStatus());
        Assert.assertNull((String)"Response entity should not have been set", (Object)response.getEntity());
        ((Session)Mockito.verify((Object)this.session)).logout();
        Assert.assertEquals((String)"NoContent response expected when no data found", (long)Response.noContent().build().getStatus(), (long)response.getStatus());
    }

    @Test
    public void testGetData() throws RepositoryException {
        Mockito.when((Object)this.accessRolesProvider.getRoles((Node)Matchers.any(Node.class), Matchers.anyBoolean())).thenReturn(this.rolesData);
        Response response = this.accessRoles.get(this.paths, "");
        Assert.assertEquals((String)"Expecting OK response", (long)Response.ok().build().getStatus(), (long)response.getStatus());
        Assert.assertEquals((String)"Response entity should match the roles data assigned to the node", (Object)response.getEntity(), this.rolesData);
        ((Session)Mockito.verify((Object)this.session)).logout();
        ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider)).getRoles((Node)Matchers.any(Node.class), Matchers.anyBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryException.class)
    public void testGetException() throws RepositoryException {
        Mockito.when((Object)this.nodeService.getObject((Session)Matchers.any(Session.class), Matchers.anyString())).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            this.accessRoles.get(this.paths, "");
        }
        finally {
            ((Session)Mockito.verify((Object)this.session)).logout();
            ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider, (VerificationMode)Mockito.never())).getRoles((Node)Matchers.any(Node.class), Matchers.anyBoolean());
        }
    }

    @Test(expected=WebApplicationException.class)
    public void testPostEmptyRoleData() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        this.invalidPost(data);
    }

    @Test(expected=WebApplicationException.class)
    public void testPostEmptyRoleSet() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put("principalName", Collections.emptySet());
        this.invalidPost(data);
    }

    @Test(expected=WebApplicationException.class)
    public void testPostNullRoleSet() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put("principalName", null);
        this.invalidPost(data);
    }

    @Test(expected=WebApplicationException.class)
    public void testPostEmptyRole() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        HashSet<String> roles = new HashSet<String>();
        roles.add(" ");
        data.put("principalName", roles);
        this.invalidPost(data);
    }

    @Test(expected=WebApplicationException.class)
    public void testPostEmptyPrincipalName() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        HashSet<String> roles = new HashSet<String>();
        roles.add("role");
        data.put(" ", roles);
        this.invalidPost(data);
    }

    @Test(expected=WebApplicationException.class)
    public void testPostNullPrincipalName() throws RepositoryException {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put(null, null);
        this.invalidPost(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidPost(Map<String, Set<String>> data) throws RepositoryException {
        try {
            this.accessRoles.post(this.paths, data);
        }
        finally {
            ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider, (VerificationMode)Mockito.never())).postRoles((Node)Matchers.any(Node.class), (Map)Matchers.any());
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save();
            ((Session)Mockito.verify((Object)this.session)).logout();
        }
    }

    @Test
    public void testApplyNewRoles() throws RepositoryException {
        HashMap data = new HashMap();
        HashSet<String> roles = new HashSet<String>();
        roles.add("role1");
        roles.add("role2");
        data.put("principalName", roles);
        Response response = this.accessRoles.post(this.paths, data);
        ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider)).postRoles((Node)Matchers.any(Node.class), (Map)Matchers.any());
        ((Session)Mockito.verify((Object)this.session)).save();
        ((Session)Mockito.verify((Object)this.session)).logout();
        Assert.assertEquals((String)"Status code must be CREATED", (long)201L, (long)response.getStatus());
        Assert.assertEquals((String)"Response path should reference accessroles", (Object)"/fcrepo/fcr:accessroles", (Object)((URI)response.getMetadata().getFirst((Object)"Location")).getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryException.class)
    public void testApplyRolesException() throws RepositoryException {
        HashMap data = new HashMap();
        HashSet<String> roles = new HashSet<String>();
        roles.add("role");
        data.put("principalName", roles);
        ((AccessRolesProvider)Mockito.doThrow((Throwable)new RepositoryException()).when((Object)this.accessRolesProvider)).postRoles((Node)Matchers.any(Node.class), (Map)Matchers.any());
        try {
            this.accessRoles.post(this.paths, data);
        }
        finally {
            ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider)).postRoles((Node)Matchers.any(Node.class), (Map)Matchers.any());
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save();
            ((Session)Mockito.verify((Object)this.session)).logout();
        }
    }

    @Test
    public void testDeleteRolesAtNode() throws RepositoryException {
        Response response = this.accessRoles.deleteNodeType(this.paths);
        Assert.assertEquals((String)"Delete response must be NO CONTENT", (long)204L, (long)response.getStatus());
        ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider)).deleteRoles((Node)Matchers.any(Node.class));
        ((Session)Mockito.verify((Object)this.session)).save();
        ((Session)Mockito.verify((Object)this.session)).logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RepositoryException.class)
    public void testDeleteRolesException() throws RepositoryException {
        ((AccessRolesProvider)Mockito.doThrow((Throwable)new RepositoryException()).when((Object)this.accessRolesProvider)).deleteRoles((Node)Matchers.any(Node.class));
        try {
            this.accessRoles.deleteNodeType(this.paths);
        }
        finally {
            ((AccessRolesProvider)Mockito.verify((Object)this.accessRolesProvider)).deleteRoles((Node)Matchers.any(Node.class));
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).save();
            ((Session)Mockito.verify((Object)this.session)).logout();
        }
    }
}

