/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.auth.roles.common.AccessRolesResources;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AccessRolesResourcesTest {
    @Mock
    private IdentifierTranslator graphSubjects;
    @Mock
    private FedoraResource fedoraResource;
    private Resource graphResource;
    @Mock
    private Node resourceNode;
    private Model model;
    private UriInfo uriInfo;
    private AccessRolesResources resources;
    private String pathString;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.resources = new AccessRolesResources();
        this.pathString = "path";
        this.model = ModelFactory.createDefaultModel();
        this.graphResource = this.model.createResource("/" + this.pathString);
        Mockito.when((Object)this.graphSubjects.getSubject(Matchers.anyString())).thenReturn((Object)this.graphResource);
        Mockito.when((Object)this.fedoraResource.getNode()).thenReturn((Object)this.resourceNode);
        this.uriInfo = TestHelpers.getUriInfoImpl();
    }

    @Test
    public void testCreateModelForNonFedoraResource() throws RepositoryException {
        Mockito.when((Object)this.resourceNode.isNodeType((String)Matchers.eq((Object)"fedora:resource"))).thenReturn((Object)false);
        Model model = this.resources.createModelForResource(this.fedoraResource, this.uriInfo, this.graphSubjects);
        Assert.assertTrue((String)"Model should be an empty default model", (boolean)model.isEmpty());
    }

    @Test
    public void testCreateModelForResource() throws RepositoryException {
        Mockito.when((Object)this.resourceNode.isNodeType((String)Matchers.eq((Object)"fedora:resource"))).thenReturn((Object)true);
        Mockito.when((Object)this.fedoraResource.getPath()).thenReturn((Object)("/" + this.pathString));
        Model model = this.resources.createModelForResource(this.fedoraResource, this.uriInfo, this.graphSubjects);
        Assert.assertFalse((String)"Model should not be empty", (boolean)model.isEmpty());
        ResIterator resIterator = model.listResourcesWithProperty(RdfLexicon.HAS_ACCESS_ROLES_SERVICE);
        Assert.assertTrue((String)"No resources with property HAS_ACCESS_ROLES_SERVICE in model", (boolean)resIterator.hasNext());
        Resource addedResource = (Resource)resIterator.next();
        Assert.assertEquals((String)"Resource localname should match URI of provided resource", (Object)this.pathString, (Object)addedResource.getLocalName());
    }
}

