/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.auth.roles.common.AccessRolesProvider;
import org.fcrepo.auth.roles.common.Constants;
import org.fcrepo.kernel.impl.testutilities.TestNodeIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.value.Path;

public class AccessRolesProviderTest {
    @Mock
    private Session session;
    @Mock
    private Node node;
    @Mock
    private Node rbaclNode;
    @Mock
    private Node principalNode1;
    @Mock
    private Property principalProperty1;
    private NodeIterator rbaclIterator;
    private AccessRolesProvider provider;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node.getSession()).thenReturn((Object)this.session);
        this.provider = new AccessRolesProvider();
        this.setupPrincipalNode(this.principalNode1, this.principalProperty1, "principal", "role");
        this.rbaclIterator = TestNodeIterator.nodeIterator((Node[])new Node[]{this.principalNode1});
        Mockito.when((Object)this.rbaclNode.getNodes()).thenReturn((Object)this.rbaclIterator);
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)false);
    }

    private void setupPrincipalNode(Node principalNode, Property principalProperty, String principalName, String roleName) throws RepositoryException {
        Mockito.when((Object)principalProperty.getString()).thenReturn((Object)principalName);
        Mockito.when((Object)principalNode.getProperty((String)Matchers.eq((Object)Constants.JcrName.principal.getQualified()))).thenReturn((Object)principalProperty);
        Property roleProperty = (Property)Mockito.mock(Property.class);
        Value roleValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)roleValue.toString()).thenReturn((Object)roleName);
        Mockito.when((Object)roleProperty.getValues()).thenReturn((Object)new Value[]{roleValue});
        Mockito.when((Object)principalNode.getProperty((String)Matchers.eq((Object)Constants.JcrName.role.getQualified()))).thenReturn((Object)roleProperty);
    }

    @Test
    public void testGetRolesNoRBACLs() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        this.rbaclIterator = TestNodeIterator.nodeIterator((Node[])new Node[0]);
        Mockito.when((Object)this.rbaclNode.getNodes()).thenReturn((Object)this.rbaclIterator);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertTrue((String)"Role response for node with no rbacl nodes should be empty", (boolean)data.isEmpty());
    }

    @Test
    public void testGetRolesRBACLsNullPrincipalName() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.principalProperty1.getString()).thenReturn(null);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertTrue((String)"Role response for node with an rbacl nodes containing no principal names should be empty", (boolean)data.isEmpty());
    }

    @Test
    public void testGetRolesRBACLsNoPrincipalName() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.principalProperty1.getString()).thenReturn((Object)"");
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertTrue((String)"Role response for node with an rbacl nodes containing no principal names should be empty", (boolean)data.isEmpty());
    }

    @Test
    public void testGetRolesRBACLPathNotFound() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode(Matchers.anyString())).thenThrow(new Throwable[]{new PathNotFoundException()});
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertTrue((String)"Roles data must be empty when rbacl path is not found", (boolean)data.isEmpty());
    }

    @Test
    public void testGetRolesNotAssignableNotEffective() throws RepositoryException {
        Map data = this.provider.getRoles(this.node, false);
        Assert.assertNull((String)"Role data should be null when retrieving from a non-assignable node", (Object)data);
    }

    @Test
    public void testGetRolesEffectiveNoParent() throws RepositoryException {
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertNull((String)"Role data should be null when retrieving from non-assignable node with no parent", (Object)data);
    }

    @Test
    public void testGetRolesEffectiveParentNotAssignable() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertNull((String)"Role data should be null when a node and all its ancestors are not assignable", (Object)data);
    }

    @Test
    public void testGetRolesEffectiveParentNotFound() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType(Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.node.getParent()).thenThrow(new Throwable[]{new ItemNotFoundException()});
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertTrue((String)"Result role data should be the default access roles object", (AccessRolesProvider.DEFAULT_ACCESS_ROLES == data ? 1 : 0) != 0);
    }

    @Test
    public void testGetRolesEffectiveImmediateParent() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
        Assert.assertTrue((String)"Data did not contain principal", (boolean)data.containsKey("principal"));
        Assert.assertEquals((String)"Role for principal did not match", (Object)"role", ((List)data.get("principal")).get(0));
    }

    @Test
    public void testGetRolesEffectiveAncestorParent() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Node parentNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode2.isNodeType(Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)parentNode2.getParent()).thenReturn((Object)parentNode1);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode2);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
        Assert.assertTrue((String)"Data did not contain principal", (boolean)data.containsKey("principal"));
        Assert.assertEquals((String)"Role for principal did not match", (Object)"role", ((List)data.get("principal")).get(0));
    }

    @Test
    public void testGetRolesEffectiveAssignableParentsSamePrincipal() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Node parentNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode2.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)true);
        Mockito.when((Object)parentNode2.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)parentNode2.getParent()).thenReturn((Object)parentNode1);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode2);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
        Assert.assertTrue((String)"Data did not contain principal", (boolean)data.containsKey("principal"));
        Assert.assertEquals((String)"Principal should only contain role from immediate parent", (long)1L, (long)((List)data.get("principal")).size());
        ((Node)Mockito.verify((Object)parentNode1, (VerificationMode)Mockito.never())).getNode(Matchers.anyString());
    }

    @Test
    public void testGetRolesEffectiveMultipleRoles() throws RepositoryException {
        Node principalNode2 = (Node)Mockito.mock(Node.class);
        Property principalProperty2 = (Property)Mockito.mock(Property.class);
        this.setupPrincipalNode(principalNode2, principalProperty2, "principal", "role2");
        this.rbaclIterator = TestNodeIterator.nodeIterator((Node[])new Node[]{this.principalNode1, principalNode2});
        Mockito.when((Object)this.rbaclNode.getNodes()).thenReturn((Object)this.rbaclIterator);
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
        Assert.assertTrue((String)"Data did not contain principal", (boolean)data.containsKey("principal"));
        Assert.assertEquals((String)"Principal should contain two roles", (long)2L, (long)((List)data.get("principal")).size());
        Assert.assertTrue((String)"Principal should be assigned 'role'", (boolean)((List)data.get("principal")).contains("role"));
        Assert.assertTrue((String)"Principal should be assigned 'role2'", (boolean)((List)data.get("principal")).contains("role2"));
    }

    @Test
    public void testGetRolesEffectiveMultiplePrincipals() throws RepositoryException {
        Node principalNode2 = (Node)Mockito.mock(Node.class);
        Property principalProperty2 = (Property)Mockito.mock(Property.class);
        this.setupPrincipalNode(principalNode2, principalProperty2, "principal2", "role");
        this.rbaclIterator = TestNodeIterator.nodeIterator((Node[])new Node[]{this.principalNode1, principalNode2});
        Mockito.when((Object)this.rbaclNode.getNodes()).thenReturn((Object)this.rbaclIterator);
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"One principal should be retrieved", (long)2L, (long)data.size());
        Assert.assertTrue((String)"Data did not contain principal", (boolean)data.containsKey("principal"));
        Assert.assertTrue((String)"Data did not contain principal2", (boolean)data.containsKey("principal2"));
        Assert.assertEquals((String)"Principal should contain only one role", (long)1L, (long)((List)data.get("principal")).size());
        Assert.assertEquals((String)"Principal2 should contain only one role", (long)1L, (long)((List)data.get("principal2")).size());
        Assert.assertTrue((boolean)((List)data.get("principal")).contains("role"));
        Assert.assertTrue((boolean)((List)data.get("principal2")).contains("role"));
    }

    @Test
    public void testGetRolesNullRoleValue() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Property roleProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)roleProperty.getValues()).thenReturn((Object)new Value[]{null});
        Mockito.when((Object)this.principalNode1.getProperty((String)Matchers.eq((Object)Constants.JcrName.role.getQualified()))).thenReturn((Object)roleProperty);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"Data should contain one principal", (long)1L, (long)data.size());
        Assert.assertEquals((String)"Principal should not contain any roles", (long)0L, (long)((List)data.get("principal")).size());
    }

    @Test
    public void testGetRolesEmptyRoleValue() throws RepositoryException {
        Node parentNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode1.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode1.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode1);
        Property roleProperty = (Property)Mockito.mock(Property.class);
        Value roleValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)roleValue.toString()).thenReturn((Object)"");
        Mockito.when((Object)roleProperty.getValues()).thenReturn((Object)new Value[]{roleValue});
        Mockito.when((Object)this.principalNode1.getProperty((String)Matchers.eq((Object)Constants.JcrName.role.getQualified()))).thenReturn((Object)roleProperty);
        Map data = this.provider.getRoles(this.node, true);
        Assert.assertEquals((String)"Data should contain one principal", (long)1L, (long)data.size());
        Assert.assertEquals((String)"Principal should not contain any roles", (long)0L, (long)((List)data.get("principal")).size());
    }

    @Test
    public void testPostRolesNonassignableEmptyData() throws RepositoryException {
        Node aclNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.node.addNode(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)aclNode);
        HashMap data = new HashMap();
        this.provider.postRoles(this.node, data);
        ((Node)Mockito.verify((Object)this.node)).addMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.node)).addNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()), (String)Matchers.eq((Object)Constants.JcrName.Rbacl.getQualified()));
        ((Node)Mockito.verify((Object)aclNode, (VerificationMode)Mockito.never())).addNode(Matchers.anyString());
    }

    @Test
    public void testPostRolesEmptyDataToRBACLAssignable() throws RepositoryException {
        HashMap data = new HashMap();
        Mockito.when((Object)this.node.isNodeType(Constants.JcrName.rbaclAssignable.getQualified())).thenReturn((Object)true);
        this.provider.postRoles(this.node, data);
        ((Node)Mockito.verify((Object)this.node, (VerificationMode)Mockito.never())).addMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.node)).addNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()), (String)Matchers.eq((Object)Constants.JcrName.Rbacl.getQualified()));
    }

    @Test
    public void testPostRolesToNonRBACLNode() throws RepositoryException {
        HashMap data = new HashMap();
        HashSet<String> roles = new HashSet<String>();
        roles.add("role");
        data.put("principal", roles);
        Node aclNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.node.addNode(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)aclNode);
        Node assignNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)aclNode.addNode(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)assignNode);
        this.provider.postRoles(this.node, data);
        ((Node)Mockito.verify((Object)this.node)).addMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.node)).addNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()), (String)Matchers.eq((Object)Constants.JcrName.Rbacl.getQualified()));
        ((Node)Mockito.verify((Object)aclNode)).addNode((String)Matchers.eq((Object)Constants.JcrName.assignment.getQualified()), (String)Matchers.eq((Object)Constants.JcrName.Assignment.getQualified()));
        ((Node)Mockito.verify((Object)assignNode)).setProperty((String)Matchers.eq((Object)Constants.JcrName.principal.getQualified()), (String)Matchers.eq((Object)"principal"));
        ((Node)Mockito.verify((Object)assignNode)).setProperty((String)Matchers.eq((Object)Constants.JcrName.role.getQualified()), (String[])Matchers.any(String[].class));
    }

    @Test
    public void testPostRolesToRBACLNode() throws RepositoryException {
        HashMap data = new HashMap();
        Mockito.when((Object)this.node.hasNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()))).thenReturn((Object)true);
        Node aclNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)aclNode.getNodes()).thenReturn((Object)this.rbaclIterator);
        Mockito.when((Object)this.node.getNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()))).thenReturn((Object)aclNode);
        this.provider.postRoles(this.node, data);
        ((Node)Mockito.verify((Object)this.node)).addMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.principalNode1)).remove();
        ((Node)Mockito.verify((Object)this.node, (VerificationMode)Mockito.never())).addNode(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testDeleteRolesNonAssignable() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)false);
        this.provider.deleteRoles(this.node);
        ((Node)Mockito.verify((Object)this.node, (VerificationMode)Mockito.never())).removeMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.node, (VerificationMode)Mockito.never())).getNode(Matchers.anyString());
    }

    @Test
    public void testDeleteRolesRBACLPathNotFound() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()))).thenThrow(new Throwable[]{new PathNotFoundException()});
        this.provider.deleteRoles(this.node);
        ((Node)Mockito.verify((Object)this.node)).removeMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
        ((Node)Mockito.verify((Object)this.node)).getNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()));
    }

    @Test
    public void testDeleteRoles() throws RepositoryException {
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode((String)Matchers.eq((Object)Constants.JcrName.rbacl.getQualified()))).thenReturn((Object)this.rbaclNode);
        this.provider.deleteRoles(this.node);
        ((Node)Mockito.verify((Object)this.rbaclNode)).remove();
        ((Node)Mockito.verify((Object)this.node)).removeMixin((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()));
    }

    @Test
    public void testFindRolesForPathRootNotAssignable() throws RepositoryException {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.isRoot()).thenReturn((Object)true);
        Mockito.when((Object)this.session.getRootNode()).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)false);
        Mockito.when((Object)this.node.getParent()).thenReturn(null);
        Map data = this.provider.findRolesForPath(path, this.session);
        Assert.assertNull((String)"Unassignable root should return no role data", (Object)data);
        ((Session)Mockito.verify((Object)this.session)).getRootNode();
        ((Node)Mockito.verify((Object)this.node)).getParent();
    }

    @Test
    public void testFindRolesForPathNotRoot() throws RepositoryException {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.isRoot()).thenReturn((Object)false);
        String pathString = "path";
        Mockito.when((Object)path.getString()).thenReturn((Object)"path");
        Mockito.when((Object)this.session.getNode((String)Matchers.eq((Object)"path"))).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)false);
        Node parentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode.isNodeType(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)parentNode.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Mockito.when((Object)this.node.getParent()).thenReturn((Object)parentNode);
        Map data = this.provider.findRolesForPath(path, this.session);
        ((Session)Mockito.verify((Object)this.session)).getNode((String)Matchers.eq((Object)"path"));
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
    }

    @Test
    public void testFindRolesForPathFirstParentPathNotFound() throws RepositoryException {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.isRoot()).thenReturn((Object)false);
        String pathString = "path";
        Mockito.when((Object)path.getString()).thenReturn((Object)"path");
        Mockito.when((Object)this.session.getNode((String)Matchers.eq((Object)"path"))).thenThrow(new Throwable[]{new PathNotFoundException()});
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.isRoot()).thenReturn((Object)true);
        Mockito.when((Object)path.getParent()).thenReturn((Object)rootPath);
        Mockito.when((Object)this.session.getRootNode()).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isNodeType((String)Matchers.eq((Object)Constants.JcrName.rbaclAssignable.getQualified()))).thenReturn((Object)true);
        Mockito.when((Object)this.node.getNode(Matchers.anyString())).thenReturn((Object)this.rbaclNode);
        Map data = this.provider.findRolesForPath(path, this.session);
        ((Session)Mockito.verify((Object)this.session)).getRootNode();
        ((Session)Mockito.verify((Object)this.session)).getNode((String)Matchers.eq((Object)"path"));
        Assert.assertEquals((String)"One principal should be retrieved", (long)1L, (long)data.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NullPointerException.class)
    public void testFindRolesForPathNullPath() throws RepositoryException {
        try {
            this.provider.findRolesForPath(null, this.session);
        }
        finally {
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).getRootNode();
            ((Node)Mockito.verify((Object)this.node, (VerificationMode)Mockito.never())).getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NullPointerException.class)
    public void testFindRolesForPathAllNotFound() throws RepositoryException {
        Mockito.when((Object)this.session.getRootNode()).thenThrow(new Throwable[]{new PathNotFoundException()});
        Mockito.when((Object)this.session.getNode(Matchers.anyString())).thenThrow(new Throwable[]{new PathNotFoundException()});
        Path path1 = (Path)Mockito.mock(Path.class);
        Path path2 = (Path)Mockito.mock(Path.class);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.isRoot()).thenReturn((Object)true);
        Mockito.when((Object)path1.getParent()).thenReturn((Object)rootPath);
        Mockito.when((Object)path2.getParent()).thenReturn((Object)path1);
        try {
            this.provider.findRolesForPath(path2, this.session);
        }
        finally {
            ((Session)Mockito.verify((Object)this.session)).getRootNode();
            ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).getNode(Matchers.anyString());
        }
    }
}

