/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.roles.common;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fcrepo.auth.roles.common.AbstractRolesAuthorizationDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AbstractRolesAuthorizationDelegateTest {
    @Mock
    private Principal principalA;
    @Mock
    private Principal principalB;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.principalA.getName()).thenReturn((Object)"a");
        Mockito.when((Object)this.principalB.getName()).thenReturn((Object)"b");
    }

    @Test
    public void shouldGatherEffectiveRolesFromMultiplePrincipals() {
        HashMap<String, List<String>> acl = new HashMap<String, List<String>>();
        acl.put("a", Arrays.asList("reader", "writer"));
        acl.put("b", Arrays.asList("admin"));
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(this.principalA);
        principals.add(this.principalB);
        Set roles = AbstractRolesAuthorizationDelegate.resolveUserRoles(acl, principals);
        Assert.assertEquals((String)"The effective roles set should contain the correct number of roles", (long)3L, (long)roles.size());
        Assert.assertTrue((String)"The effective roles set should contain the reader role", (boolean)roles.contains("reader"));
        Assert.assertTrue((String)"The effective roles set should contain the writer role", (boolean)roles.contains("writer"));
        Assert.assertTrue((String)"The effective roles set should contain the admin role", (boolean)roles.contains("admin"));
    }

    @Test
    public void shouldHandleUnmatchedRoles() {
        HashMap acl = new HashMap();
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(this.principalA);
        Set roles = AbstractRolesAuthorizationDelegate.resolveUserRoles(acl, principals);
        Assert.assertEquals((String)"The effective roles set should contain no roles if there is no entry in the ACL", (long)0L, (long)roles.size());
    }
}

