/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.audit.triplestore.AuditSparqlProcessor;
import org.fcrepo.camel.audit.triplestore.FcrepoAuditTriplestoreConfig;
import org.fcrepo.camel.common.processor.AddBasicAuthProcessor;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.camel.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EventRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRouter.class);
    @Autowired
    private FcrepoAuditTriplestoreConfig config;

    public void configure() throws Exception {
        this.onException(Exception.class).maximumRedeliveries(this.config.getMaxRedeliveries()).log("Event Routing Error: ${routeId}");
        ((RouteDefinition)this.from(this.config.getInputStream()).routeId("AuditFcrepoRouter").process((Processor)new EventProcessor())).filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(ProcessorUtils.tokenizePropertyPlaceholder((CamelContext)this.getContext(), (String)this.config.getFilterContainers(), (String)",").stream().map(uri -> PredicateBuilder.or((Predicate)this.header("CamelFcrepoUri").startsWith((Object)this.constant(uri + "/")), (Predicate)this.header("CamelFcrepoUri").isEqualTo((Object)this.constant(uri)))).collect(Collectors.toList())))).to("direct:event");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:event").routeId("AuditEventRouter").setHeader("CamelAuditEventBaseUri", (Expression)this.simple(this.config.getEventBaseUri()))).process((Processor)new AuditSparqlProcessor())).log(LoggingLevel.INFO, "org.fcrepo.camel.audit", "Audit Event: ${headers.CamelFcrepoUri} :: ${headers[CamelAuditEventUri]}")).process((Processor)new AddBasicAuthProcessor(this.config.getTriplestoreAuthUsername(), this.config.getTriplestoreAuthPassword()))).to(this.config.getTriplestoreBaseUrl() + "?useSystemProperties=true");
    }
}

