/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.vocabulary.RDF;
import org.fcrepo.camel.processor.ProcessorUtils;

public class AuditSparqlProcessor
implements Processor {
    static final String AUDIT = "http://fedora.info/definitions/v4/audit#";
    static final String PREMIS = "http://www.loc.gov/premis/rdf/v1#";
    static final String PROV = "http://www.w3.org/ns/prov#";
    static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    static final String EVENT_TYPE = "http://id.loc.gov/vocabulary/preservation/eventType/";
    static final String EVENT_NAMESPACE = "http://fedora.info/definitions/v4/event#";
    static final String AS_NAMESPACE = "https://www.w3.org/ns/activitystreams#";
    static final String REPOSITORY = "http://fedora.info/definitions/v4/repository#";
    static final String CONTENT_MOD = "http://fedora.info/definitions/v4/audit#contentModification";
    static final String CONTENT_REM = "http://fedora.info/definitions/v4/audit#contentRemoval";
    static final String METADATA_MOD = "http://fedora.info/definitions/v4/audit#metadataModification";
    static final String CONTENT_ADD = "http://id.loc.gov/vocabulary/preservation/eventType/ing";
    static final String OBJECT_ADD = "http://id.loc.gov/vocabulary/preservation/eventType/cre";
    static final String OBJECT_REM = "http://id.loc.gov/vocabulary/preservation/eventType/del";
    private static final Resource INTERNAL_EVENT = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/audit#InternalEvent");
    private static final Resource PREMIS_EVENT = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#Event");
    private static final Resource PROV_EVENT = ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#InstantaneousEvent");
    private static final Property PREMIS_TIME = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    private static final Property PREMIS_OBJ = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedObject");
    private static final Property PREMIS_AGENT = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedAgent");
    private static final Property PREMIS_TYPE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventType");
    private static final String EMPTY_STRING = "";

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String eventURIBase = (String)in.getHeader("CamelAuditEventBaseUri", String.class);
        String eventID = (String)in.getHeader("CamelFcrepoEventId", String.class);
        Resource eventURI = ResourceFactory.createResource((String)(eventURIBase + "/" + eventID));
        StringBuilder query = new StringBuilder("update=");
        query.append(ProcessorUtils.insertData((String)AuditSparqlProcessor.serializedGraphForMessage(in, eventURI), (String)EMPTY_STRING));
        in.setBody((Object)query.toString());
        in.setHeader("CamelAuditEventUri", (Object)eventURI.toString());
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        in.setHeader("CamelHttpMethod", (Object)"POST");
    }

    private static String serializedGraphForMessage(Message message, Resource subject) throws IOException {
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        Model model = ModelFactory.createDefaultModel();
        List eventType = (List)message.getHeader("CamelFcrepoEventType", Collections.emptyList(), List.class);
        String dateTime = (String)message.getHeader("CamelFcrepoDateTime", (Object)EMPTY_STRING, String.class);
        List agents = (List)message.getHeader("CamelFcrepoAgent", Collections.emptyList(), List.class);
        List resourceTypes = (List)message.getHeader("CamelFcrepoResourceType", Collections.emptyList(), List.class);
        String identifier = (String)message.getHeader("CamelFcrepoUri", (Object)EMPTY_STRING, String.class);
        Optional<String> premisType = AuditSparqlProcessor.getAuditEventType(eventType, resourceTypes);
        model.add(model.createStatement(subject, RDF.type, (RDFNode)INTERNAL_EVENT));
        model.add(model.createStatement(subject, RDF.type, (RDFNode)PREMIS_EVENT));
        model.add(model.createStatement(subject, RDF.type, (RDFNode)PROV_EVENT));
        model.add(model.createStatement(subject, PREMIS_TIME, (RDFNode)ResourceFactory.createTypedLiteral((String)dateTime, (RDFDatatype)XSDDatatype.XSDdateTime)));
        model.add(model.createStatement(subject, PREMIS_OBJ, (RDFNode)ResourceFactory.createResource((String)identifier)));
        agents.forEach(agent -> model.add(model.createStatement(subject, PREMIS_AGENT, (RDFNode)ResourceFactory.createTypedLiteral((String)agent, (RDFDatatype)XSDDatatype.XSDstring))));
        premisType.ifPresent(rdfType -> model.add(model.createStatement(subject, PREMIS_TYPE, (RDFNode)ResourceFactory.createResource((String)rdfType))));
        RDFDataMgr.write((OutputStream)serializedGraph, (Model)model, (RDFFormat)RDFFormat.NTRIPLES);
        return serializedGraph.toString("UTF-8");
    }

    private static Optional<String> getAuditEventType(List<String> eventType, List<String> resourceType) {
        if (eventType.contains("http://fedora.info/definitions/v4/event#ResourceCreation") || eventType.contains("https://www.w3.org/ns/activitystreams#Create")) {
            if (resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return Optional.of(CONTENT_ADD);
            }
            return Optional.of(OBJECT_ADD);
        }
        if (eventType.contains("http://fedora.info/definitions/v4/event#ResourceDeletion") || eventType.contains("https://www.w3.org/ns/activitystreams#Delete")) {
            if (resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return Optional.of(CONTENT_REM);
            }
            return Optional.of(OBJECT_REM);
        }
        if (eventType.contains("http://fedora.info/definitions/v4/event#ResourceModification") || eventType.contains("https://www.w3.org/ns/activitystreams#Update")) {
            if (resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return Optional.of(CONTENT_MOD);
            }
            return Optional.of(METADATA_MOD);
        }
        return Optional.empty();
    }
}

