/*
 * Decompiled with CFR 0.152.
 */
package org.fanjr.simplify.zk.server;

import org.fanjr.simplify.zk.server.ZkServerBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Order(value=0x7FFFFFFF)
public class ZkServerConfiguration
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private ZkServerBean bean;

    @Bean
    public ZkServerBean zkServerBean() {
        return this.bean;
    }

    public void setEnvironment(Environment environment) {
        if (((Boolean)environment.getProperty("zookeeper.simplify.enableLogo", Boolean.TYPE, (Object)true)).booleanValue()) {
            this.printLogo();
        }
        this.bean = new ZkServerBean(environment);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void printLogo() {
        System.out.println("  ___ _            _ _  __         _____       ___                     \r\n / __(_)_ __  _ __| (_)/ _|_  _ __|_  | |_____/ __|___ _ ___ _____ _ _ \r\n \\__ | | '  \\| '_ | | |  _| || |___/ /| / |___\\__ / -_| '_\\ V / -_| '_|\r\n |___|_|_|_|_| .__|_|_|_|  \\_, |  /___|_\\_\\   |___\\___|_|  \\_/\\___|_|  \r\n             |_|           |__/                                        ");
    }
}

