/*
 * Decompiled with CFR 0.152.
 */
package org.fanjr.simplify.zk.server;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ZkServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZkServer.class);
    private ZooKeeperServer zkServer;
    private ServerCnxnFactory cnxnFactory;

    private ZkServer(ZooKeeperServer zkServer, ServerCnxnFactory cnxnFactory) {
        this.zkServer = zkServer;
        this.cnxnFactory = cnxnFactory;
    }

    public static ZkServer runDefault() throws IOException, QuorumPeerConfig.ConfigException {
        try {
            return ZkServer.runFromProperties(new Properties());
        }
        catch (IOException | QuorumPeerConfig.ConfigException e) {
            LOGGER.error("Start zookeeper server error!", e);
            throw e;
        }
    }

    public static ZkServer runFromProperties(Properties properties) throws QuorumPeerConfig.ConfigException, IOException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        ZkServer.initDefaultValue("dataDir", "zkData", properties);
        ZkServer.initDefaultValue("clientPort", "2181", properties);
        quorumPeerConfig.parseProperties(properties);
        ServerConfig config = new ServerConfig();
        config.readFrom(quorumPeerConfig);
        return ZkServer.runFromConfig(config);
    }

    public static ZkServer runFromConfig(ServerConfig config) throws IOException {
        LOGGER.info("Starting zookeeper server");
        FileTxnSnapLog txnLog = null;
        ZooKeeperServer zkServer = new ZooKeeperServer();
        txnLog = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
        txnLog.setServerStats(zkServer.serverStats());
        zkServer.setTxnLogFactory(txnLog);
        zkServer.setTickTime(config.getTickTime());
        zkServer.setMinSessionTimeout(config.getMinSessionTimeout());
        zkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
        try {
            cnxnFactory.startup(zkServer);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new ZkServer(zkServer, cnxnFactory);
    }

    public void destroy() {
        if (this.cnxnFactory != null) {
            this.cnxnFactory.shutdown();
        }
    }

    public ZooKeeperServer getZkServer() {
        return this.zkServer;
    }

    private static void initDefaultValue(String key, String defaultValue, Properties properties) {
        if (!StringUtils.hasText((String)((String)properties.get(key)))) {
            properties.put(key, defaultValue);
        }
    }
}

