/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.junit.platform.commons.util.ReflectionUtils;
import org.springframework.test.context.TestContext;

public interface FactCastIntegrationTestExtension {
    default public boolean initialize() {
        return true;
    }

    default public String createUnableToInitializeMessage() {
        return "reason unknown";
    }

    default public void prepareContainers(TestContext ctx) {
    }

    default public void wipeExternalDataStore(TestContext ctx) {
    }

    default public void injectFields(TestContext ctx) {
    }

    default public void beforeAll(TestContext ctx) {
    }

    default public void beforeEach(TestContext ctx) {
    }

    default public void afterEach(TestContext ctx) {
    }

    default public void afterAll(TestContext ctx) {
    }

    public static void inject(@NonNull Object testInstance, @NonNull Class<?> targetType, @Nullable Object toInject) {
        Objects.requireNonNull(testInstance, "testInstance is marked non-null but is null");
        Objects.requireNonNull(targetType, "targetType is marked non-null but is null");
        List proxyFields = ReflectionUtils.findFields(testInstance.getClass(), f -> targetType.equals(f.getType()), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        proxyFields.forEach(f -> FactCastIntegrationTestExtension.setFieldValue(f, testInstance, toInject));
    }

    public static void inject(@NonNull Object testInstance, @NonNull Object toInject) {
        Objects.requireNonNull(testInstance, "testInstance is marked non-null but is null");
        Objects.requireNonNull(toInject, "toInject is marked non-null but is null");
        FactCastIntegrationTestExtension.inject(testInstance, toInject.getClass(), toInject);
    }

    public static void setFieldValue(Field f, Object t, Object value) {
        f.setAccessible(true);
        f.set(t, value);
    }
}

