/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.sql.DataSource;
import lombok.Generated;
import org.factcast.test.AbstractFactCastIntegrationTest;
import org.factcast.test.FactCastIntegrationTestExecutionListener;
import org.factcast.test.FactCastIntegrationTestExtension;
import org.factcast.test.FactcastTestConfig;
import org.factcast.test.toxi.FactCastProxy;
import org.factcast.test.toxi.PostgresqlProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.lifecycle.Startable;

public class BaseIntegrationTestExtension
implements FactCastIntegrationTestExtension {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseIntegrationTestExtension.class);
    private static final int FC_PORT = 9090;
    private static final int PG_PORT = 5432;
    private static final Map<FactcastTestConfig.Config, FactCastIntegrationTestExecutionListener.Containers> executions = new ConcurrentHashMap<FactcastTestConfig.Config, FactCastIntegrationTestExecutionListener.Containers>();

    @Override
    public void prepareContainers(TestContext ctx) {
        FactcastTestConfig.Config config = this.discoverConfig(ctx.getTestClass());
        this.startOrReuse(config);
    }

    @Override
    public void wipeExternalDataStore(TestContext ctx) {
        this.erasePostgres((DataSource)ctx.getApplicationContext().getBean(DataSource.class));
    }

    @Override
    public void injectFields(TestContext testContext) {
        FactcastTestConfig.Config config = this.discoverConfig(testContext.getTestClass());
        Object t = testContext.getTestInstance();
        FactCastIntegrationTestExtension.inject(t, executions.get(config).pgProxy());
        FactCastIntegrationTestExtension.inject(t, executions.get(config).fcProxy());
    }

    private FactcastTestConfig.Config discoverConfig(Class<?> testClass) {
        return Optional.ofNullable(testClass).flatMap(x -> Optional.ofNullable(x.getAnnotation(FactcastTestConfig.class))).map(FactcastTestConfig.Config::from).orElse(FactcastTestConfig.Config.defaults());
    }

    public void startOrReuse(FactcastTestConfig.Config config) {
        FactCastIntegrationTestExecutionListener.Containers containers = executions.computeIfAbsent(config, key -> {
            String dbName = "db" + config.hashCode();
            PostgreSQLContainer db = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer("postgres:" + config.postgresVersion()).withDatabaseName("fc").withUsername("fc").withPassword(UUID.randomUUID().toString()).withNetworkAliases(new String[]{dbName})).withNetwork(FactCastIntegrationTestExecutionListener._docker_network);
            db.start();
            ToxiproxyContainer.ContainerProxy pgProxy = FactCastIntegrationTestExecutionListener.createProxy(db, 5432);
            String jdbcUrl = "jdbc:postgresql://toxiproxy:" + pgProxy.getOriginalProxyPort() + "/" + db.getDatabaseName();
            GenericContainer fc = ((GenericContainer)new GenericContainer("factcast/factcast:" + config.factcastVersion()).withExposedPorts(new Integer[]{9090}).withFileSystemBind(config.configDir(), "/config/")).withEnv("grpc_server_port", String.valueOf(9090)).withEnv("factcast_security_enabled", "false").withEnv("factcast_grpc_bandwidth_disabled", "true").withEnv("factcast_store_integrationTestMode", "true").withEnv("spring_datasource_url", jdbcUrl).withEnv("spring_datasource_username", db.getUsername()).withEnv("spring_datasource_password", db.getPassword()).withNetwork(FactCastIntegrationTestExecutionListener._docker_network).dependsOn(new Startable[]{db}).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(AbstractFactCastIntegrationTest.class))).waitingFor(new HostPortWaitStrategy().withStartupTimeout(Duration.ofSeconds(180L)));
            fc.start();
            ToxiproxyContainer.ContainerProxy fcProxy = FactCastIntegrationTestExecutionListener.createProxy(fc, 9090);
            return new FactCastIntegrationTestExecutionListener.Containers(db, fc, new PostgresqlProxy(pgProxy, FactCastIntegrationTestExecutionListener.client()), new FactCastProxy(fcProxy, FactCastIntegrationTestExecutionListener.client()), jdbcUrl);
        });
        ToxiproxyContainer.ContainerProxy fcProxy = containers.fcProxy().get();
        String address = "static://" + fcProxy.getContainerIpAddress() + ":" + fcProxy.getProxyPort();
        System.setProperty("grpc.client.factstore.address", address);
        System.setProperty("spring.datasource.url", containers.db().getJdbcUrl());
        System.setProperty("spring.datasource.username", containers.db().getUsername());
        System.setProperty("spring.datasource.password", containers.db().getPassword());
    }

    private void erasePostgres(DataSource ds) throws SQLException {
        log.trace("erasing postgres state in between tests");
        try (Connection con = ds.getConnection();
             Statement st = con.createStatement();){
            st.execute("DO $$ DECLARE\n    r RECORD;\nBEGIN\n    FOR r IN (SELECT tablename FROM pg_tables WHERE schemaname = current_schema() AND (NOT ((tablename like 'databasechangelog%') OR (tablename like 'qrtz%') OR (tablename = 'schedlock')))) LOOP\n        EXECUTE 'TRUNCATE TABLE ' || quote_ident(r.tablename) || ' RESTART IDENTITY ';\n    END LOOP;\nEND $$;");
        }
    }
}

