/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.factcast.test.AbstractFactCastIntegrationTest;
import org.factcast.test.FactCastExtension;
import org.factcast.test.FactCastIntegrationTestExtension;
import org.factcast.test.FactcastTestConfig;
import org.factcast.test.toxi.FactCastProxy;
import org.factcast.test.toxi.PostgresqlProxy;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.lifecycle.Startable;

public class BaseIntegrationTestExtension
implements FactCastIntegrationTestExtension {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseIntegrationTestExtension.class);
    private static final int FC_PORT = 9090;
    private static final int PG_PORT = 5432;
    private final Map<FactcastTestConfig.Config, Containers> executions = new ConcurrentHashMap<FactcastTestConfig.Config, Containers>();

    @Override
    public boolean initialize(ExtensionContext ctx) {
        FactcastTestConfig.Config config = this.discoverConfig(ctx);
        this.startOrReuse(config);
        return true;
    }

    private void startOrReuse(FactcastTestConfig.Config config) {
        Containers containers = this.executions.computeIfAbsent(config, key -> {
            String dbName = "db" + config.hashCode();
            PostgreSQLContainer db = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer("postgres:" + config.postgresVersion()).withDatabaseName("fc").withUsername("fc").withPassword("fc").withNetworkAliases(new String[]{dbName})).withNetwork(FactCastExtension._docker_network);
            db.start();
            ToxiproxyContainer.ContainerProxy pgProxy = FactCastExtension.proxy(db, 5432);
            GenericContainer fc = ((GenericContainer)new GenericContainer("factcast/factcast:" + config.factcastVersion()).withExposedPorts(new Integer[]{9090}).withFileSystemBind(config.configDir(), "/config/")).withEnv("grpc_server_port", String.valueOf(9090)).withEnv("factcast_security_enabled", "false").withEnv("factcast_grpc_bandwidth_disabled", "true").withEnv("factcast_store_integrationTestMode", "true").withEnv("spring_datasource_url", "jdbc:postgresql://toxiproxy:" + pgProxy.getOriginalProxyPort() + "/fc?user=fc&password=fc").withNetwork(FactCastExtension._docker_network).dependsOn(new Startable[]{db}).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(AbstractFactCastIntegrationTest.class))).waitingFor(new HostPortWaitStrategy().withStartupTimeout(Duration.ofSeconds(180L)));
            fc.start();
            ToxiproxyContainer.ContainerProxy fcProxy = FactCastExtension.proxy(fc, 9090);
            return new Containers(db, fc, new PostgresqlProxy(pgProxy), new FactCastProxy(fcProxy));
        });
        ToxiproxyContainer.ContainerProxy fcProxy = containers.fcProxy.get();
        String address = "static://" + fcProxy.getContainerIpAddress() + ":" + fcProxy.getProxyPort();
        System.setProperty("grpc.client.factstore.address", address);
    }

    @Override
    public void beforeAll(ExtensionContext ctx) {
        FactcastTestConfig.Config config = this.discoverConfig(ctx);
        this.startOrReuse(config);
        FactCastIntegrationTestExtension.super.beforeAll(ctx);
    }

    private FactcastTestConfig.Config discoverConfig(ExtensionContext ctx) {
        return ctx.getTestClass().flatMap(x -> Optional.ofNullable(x.getAnnotation(FactcastTestConfig.class))).map(FactcastTestConfig.Config::from).orElse(FactcastTestConfig.Config.defaults());
    }

    @Override
    public void beforeEach(ExtensionContext ctx) {
        FactCastIntegrationTestExtension.super.beforeEach(ctx);
        FactcastTestConfig.Config config = this.discoverConfig(ctx);
        Containers containers = this.executions.get(config);
        ctx.getTestInstance().ifPresent(t -> {
            FactCastIntegrationTestExtension.inject(t, containers.pgProxy);
            FactCastIntegrationTestExtension.inject(t, containers.fcProxy);
        });
        this.erasePostgres(containers);
    }

    @Override
    public void afterEach(ExtensionContext ctx) {
        this.erasePostgres(this.executions.get(this.discoverConfig(ctx)));
        FactCastIntegrationTestExtension.super.afterEach(ctx);
    }

    private void erasePostgres(Containers containers) throws SQLException {
        PostgreSQLContainer pg = containers.db;
        String url = pg.getJdbcUrl();
        Properties p = new Properties();
        p.put("user", pg.getUsername());
        p.put("password", pg.getPassword());
        log.trace("erasing postgres state in between tests for {}", (Object)url);
        try (Connection con = DriverManager.getConnection(url, p);
             Statement st = con.createStatement();){
            st.execute("DO $$ DECLARE\n    r RECORD;\nBEGIN\n    FOR r IN (SELECT tablename FROM pg_tables WHERE schemaname = current_schema() AND (NOT ((tablename like 'databasechangelog%') OR (tablename like 'qrtz%') OR (tablename = 'schedlock')))) LOOP\n        EXECUTE 'TRUNCATE TABLE ' || quote_ident(r.tablename) || ' RESTART IDENTITY ';\n    END LOOP;\nEND $$;");
        }
    }

    static final class Containers {
        private final PostgreSQLContainer db;
        private final GenericContainer fc;
        private final PostgresqlProxy pgProxy;
        private final FactCastProxy fcProxy;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Containers(PostgreSQLContainer db, GenericContainer fc, PostgresqlProxy pgProxy, FactCastProxy fcProxy) {
            this.db = db;
            this.fc = fc;
            this.pgProxy = pgProxy;
            this.fcProxy = fcProxy;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PostgreSQLContainer db() {
            return this.db;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GenericContainer fc() {
            return this.fc;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PostgresqlProxy pgProxy() {
            return this.pgProxy;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FactCastProxy fcProxy() {
            return this.fcProxy;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Containers)) {
                return false;
            }
            Containers other = (Containers)o;
            PostgreSQLContainer this$db = this.db();
            PostgreSQLContainer other$db = other.db();
            if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
                return false;
            }
            GenericContainer this$fc = this.fc();
            GenericContainer other$fc = other.fc();
            if (this$fc == null ? other$fc != null : !this$fc.equals(other$fc)) {
                return false;
            }
            PostgresqlProxy this$pgProxy = this.pgProxy();
            PostgresqlProxy other$pgProxy = other.pgProxy();
            if (this$pgProxy == null ? other$pgProxy != null : !this$pgProxy.equals(other$pgProxy)) {
                return false;
            }
            FactCastProxy this$fcProxy = this.fcProxy();
            FactCastProxy other$fcProxy = other.fcProxy();
            return !(this$fcProxy == null ? other$fcProxy != null : !this$fcProxy.equals(other$fcProxy));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PostgreSQLContainer $db = this.db();
            result = result * 59 + ($db == null ? 43 : $db.hashCode());
            GenericContainer $fc = this.fc();
            result = result * 59 + ($fc == null ? 43 : $fc.hashCode());
            PostgresqlProxy $pgProxy = this.pgProxy();
            result = result * 59 + ($pgProxy == null ? 43 : $pgProxy.hashCode());
            FactCastProxy $fcProxy = this.fcProxy();
            result = result * 59 + ($fcProxy == null ? 43 : $fcProxy.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "BaseIntegrationTestExtension.Containers(db=" + this.db() + ", fc=" + this.fc() + ", pgProxy=" + this.pgProxy() + ", fcProxy=" + this.fcProxy() + ")";
        }
    }
}

