/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ReflectionUtils;

public interface FactCastIntegrationTestExtension {
    default public boolean initialize(ExtensionContext context) {
        return true;
    }

    default public String createUnableToInitializeMessage() {
        return "reason unknown";
    }

    default public void beforeAll(ExtensionContext ctx) {
    }

    default public void beforeEach(ExtensionContext ctx) {
    }

    default public void afterEach(ExtensionContext ctx) {
    }

    default public void afterAll(ExtensionContext ctx) {
    }

    public static void inject(@NonNull Object testInstance, @NonNull Object toInject) {
        Objects.requireNonNull(testInstance, "testInstance is marked non-null but is null");
        Objects.requireNonNull(toInject, "toInject is marked non-null but is null");
        List proxyFields = ReflectionUtils.findFields(testInstance.getClass(), f -> toInject.getClass().equals(f.getType()), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        proxyFields.forEach(f -> FactCastIntegrationTestExtension.setFieldValue(f, testInstance, toInject));
    }

    public static void setFieldValue(Field f, Object t, Object value) {
        f.setAccessible(true);
        f.set(t, value);
    }
}

