/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.factcast.test.FactCastIntegrationTestExtension;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.utility.DockerImageName;

public class FactCastExtension
implements Extension,
BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FactCastExtension.class);
    public static final Network _docker_network = Network.newNetwork();
    public static final String TOXIPROXY_NETWORK_ALIAS = "toxiproxy";
    private static boolean initialized = false;
    private static final List<FactCastIntegrationTestExtension> extensions = new LinkedList<FactCastIntegrationTestExtension>();
    private static List<FactCastIntegrationTestExtension> reverseExtensions;
    private static ToxiproxyContainer toxiProxy;
    private static ToxiproxyClient toxiClient;

    public void beforeEach(ExtensionContext context) throws Exception {
        FactCastExtension.resetProxy();
        for (FactCastIntegrationTestExtension e : extensions) {
            e.beforeEach(context);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        for (FactCastIntegrationTestExtension e : reverseExtensions) {
            e.afterAll(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        FactCastExtension.resetProxy();
        for (FactCastIntegrationTestExtension e : reverseExtensions) {
            e.afterEach(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        List<FactCastIntegrationTestExtension> list = extensions;
        synchronized (list) {
            if (!initialized) {
                this.initialize(context);
                initialized = true;
            }
        }
        for (FactCastIntegrationTestExtension e : extensions) {
            e.beforeAll(context);
        }
    }

    private void initialize(ExtensionContext context) {
        FactCastExtension.initializeProxy();
        ArrayList discovered = Lists.newArrayList(ServiceLoader.load(FactCastIntegrationTestExtension.class).iterator());
        AtomicInteger count = new AtomicInteger(discovered.size());
        while (!discovered.isEmpty()) {
            for (FactCastIntegrationTestExtension e : discovered) {
                if (!e.initialize(context)) continue;
                extensions.add(e);
            }
            discovered.removeAll(extensions);
            if (discovered.size() != count.getAndSet(discovered.size())) continue;
            throw new IllegalStateException("Failed to initialize extensions:\n" + discovered.stream().map(f -> " " + f.getClass() + ": " + f.createUnableToInitializeMessage()).collect(Collectors.joining(",\n")));
        }
        reverseExtensions = Lists.newArrayList(extensions);
        Collections.reverse(reverseExtensions);
    }

    private static void initializeProxy() {
        toxiProxy = (ToxiproxyContainer)((ToxiproxyContainer)new ToxiproxyContainer(DockerImageName.parse((String)"ghcr.io/shopify/toxiproxy:2.4.0").asCompatibleSubstituteFor("shopify/toxiproxy")).withNetwork(_docker_network)).withNetworkAliases(new String[]{TOXIPROXY_NETWORK_ALIAS});
        toxiProxy.start();
        String host = toxiProxy.getHost();
        int controlPort = toxiProxy.getControlPort();
        toxiClient = new ToxiproxyClient(host, controlPort);
    }

    public static ToxiproxyContainer.ContainerProxy proxy(String host, int port) {
        return toxiProxy.getProxy(host, port);
    }

    public static ToxiproxyContainer.ContainerProxy proxy(GenericContainer<?> container, int port) {
        return toxiProxy.getProxy(container, port);
    }

    public static void resetProxy() {
        toxiClient.reset();
    }

    public static void setProxyState(String name, boolean shouldBeOn) {
        Proxy proxy = toxiClient.getProxy(name);
        if (shouldBeOn) {
            proxy.enable();
        } else {
            proxy.disable();
        }
    }

    public static ToxiproxyClient client() {
        return toxiClient;
    }
}

