/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Optional;
import lombok.Generated;
import org.factcast.test.RedisEraser;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class RedisExtension
implements Extension,
BeforeEachCallback {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisExtension.class);

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Class<?> testClass = (Class<?>)extensionContext.getTestClass().orElseThrow(() -> new IllegalArgumentException("TestClass cannot be resolved"));
        while (testClass.getEnclosingClass() != null) {
            testClass = testClass.getEnclosingClass();
        }
        Optional<GenericContainer<?>> redis = this.findRedis(testClass);
        if (redis.isPresent()) {
            log.debug("Wiping Redis");
            RedisEraser.wipeAllDataFromRedis(redis.get());
        } else {
            log.warn("No static field of type {} found, so wiping data from Redis was not possible.", (Object)GenericContainer.class.getName());
        }
    }

    private Optional<? extends GenericContainer<?>> findRedis(Class<?> testClass) {
        return ReflectionUtils.findFields(testClass, RedisExtension::isRedisContainer, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().filter(c -> GenericContainer.class.isAssignableFrom(c.getType())).map(f -> {
            try {
                f.setAccessible(true);
                return (GenericContainer)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot get value from (supposedly static) field " + f);
            }
        }).findAny();
    }

    private static boolean isRedisContainer(Field f) {
        try {
            return ModifierSupport.isStatic((Member)f) && GenericContainer.class.isAssignableFrom(f.getType()) && ((GenericContainer)f.get(null)).getDockerImageName().contains("redis:");
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }
}

