/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Optional;
import lombok.Generated;
import org.factcast.test.PostgresEraser;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PostgreSQLContainer;

public class FactCastExtension
implements Extension,
BeforeEachCallback {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FactCastExtension.class);

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Optional<PostgreSQLContainer<?>> pg = this.findPG((Class)extensionContext.getTestClass().orElseThrow(() -> new IllegalArgumentException("TestClass cannot be resolved")));
        if (pg.isPresent()) {
            PostgresEraser.wipeAllFactCastDataDataFromPostgres(pg.get());
        } else {
            log.warn("No static field of type {} found, so wiping data from Postgres was not possible." + PostgreSQLContainer.class.getCanonicalName());
        }
    }

    private Optional<? extends PostgreSQLContainer<?>> findPG(Class<?> testClass) {
        return ReflectionUtils.findFields(testClass, FactCastExtension::isPostgresContainer, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(f -> {
            try {
                f.setAccessible(true);
                return (PostgreSQLContainer)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot get value from (supposedly static) field " + f);
            }
        }).findAny();
    }

    private static boolean isPostgresContainer(Field f) {
        return ModifierSupport.isStatic((Member)f) && PostgreSQLContainer.class.isAssignableFrom(f.getType());
    }
}

