/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.function.Consumer;
import lombok.Generated;
import org.factcast.test.FactCastExtension;
import org.factcast.test.RedisExtension;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.lifecycle.Startable;

@Testcontainers(disabledWithoutDocker=true)
@ExtendWith(value={FactCastExtension.class, RedisExtension.class})
public class AbstractFactCastIntegrationTest {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractFactCastIntegrationTest.class);
    protected static final Network _docker_network = Network.newNetwork();
    @Container
    protected static final PostgreSQLContainer _postgres = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer("postgres:11.5").withDatabaseName("fc").withUsername("fc").withPassword("fc").withNetworkAliases(new String[]{"db"})).withNetwork(_docker_network);
    @Container
    protected static final GenericContainer _factcast = ((GenericContainer)new GenericContainer("factcast/factcast:latest").withExposedPorts(new Integer[]{9090}).withFileSystemBind("./config", "/config/")).withEnv("grpc_server_port", "9090").withEnv("factcast_security_enabled", "false").withEnv("spring_datasource_url", "jdbc:postgresql://db/fc?user=fc&password=fc").withNetwork(_docker_network).dependsOn(new Startable[]{_postgres}).withLogConsumer((Consumer)new Slf4jLogConsumer(log)).waitingFor(new HostPortWaitStrategy().withStartupTimeout(Duration.ofSeconds(180L)));
    @Container
    static final GenericContainer _redis = new GenericContainer("redis:5.0.9-alpine").withExposedPorts(new Integer[]{6379});

    @BeforeAll
    public static void startContainers() throws InterruptedException {
        String address = "static://" + _factcast.getHost() + ":" + _factcast.getMappedPort(9090);
        System.setProperty("grpc.client.factstore.address", address);
        System.setProperty("spring.redis.host", _redis.getHost());
        System.setProperty("spring.redis.port", String.valueOf(_redis.getMappedPort(6379)));
    }
}

