/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.inmem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.spec.FactSpecMatcher;
import org.factcast.core.store.AbstractFactStore;
import org.factcast.core.store.StateToken;
import org.factcast.core.store.TokenStore;
import org.factcast.core.subscription.Subscription;
import org.factcast.core.subscription.SubscriptionImpl;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.core.subscription.observer.FactObserver;
import org.factcast.core.subscription.observer.GenericObserver;
import org.factcast.store.inmem.InMemFact;
import org.factcast.store.inmem.InMemTokenStore;

@Deprecated
public class InMemFactStore
extends AbstractFactStore {
    private final AtomicLong highwaterMark = new AtomicLong(0L);
    private final Map<Long, Fact> store = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<UUID, Long> factid2ser = Collections.synchronizedMap(new LinkedHashMap());
    private final Set<UUID> ids = new HashSet<UUID>();
    private final CopyOnWriteArrayList<InMemFollower> activeFollowers = new CopyOnWriteArrayList();
    private final ExecutorService executorService;

    InMemFactStore(@NonNull ExecutorService e) {
        super((TokenStore)new InMemTokenStore());
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        this.executorService = e;
    }

    public InMemFactStore() {
        this(Executors.newCachedThreadPool());
    }

    public synchronized Optional<Fact> fetchById(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Stream stream = this.store.entrySet().stream();
        return stream.filter(e -> ((Fact)e.getValue()).id().equals(id)).findFirst().map(Map.Entry::getValue);
    }

    public synchronized void publish(@NonNull List<? extends Fact> factsToPublish) {
        if (factsToPublish == null) {
            throw new NullPointerException("factsToPublish is marked non-null but is null");
        }
        if (factsToPublish.stream().anyMatch(f -> this.ids.contains(f.id()))) {
            throw new IllegalArgumentException("duplicate ids - ids must be unique!");
        }
        if (factsToPublish.stream().filter(f -> f.meta("unique_identifier") != null).collect(Collectors.groupingBy(f -> f.meta("unique_identifier"))).values().stream().anyMatch(c -> c.size() > 1)) {
            throw new IllegalArgumentException("duplicate unique_identifier in factsToPublish - unique_identifier must be unique!");
        }
        factsToPublish.forEach(f -> {
            long ser = this.highwaterMark.incrementAndGet();
            InMemFact inMemFact = new InMemFact(ser, (Fact)f);
            this.store.put(ser, (Fact)inMemFact);
            this.factid2ser.put(inMemFact.id(), ser);
            this.ids.add(inMemFact.id());
            List<InMemFollower> subscribers = this.activeFollowers.stream().filter(arg_0 -> InMemFactStore.lambda$null$5((Fact)inMemFact, arg_0)).collect(Collectors.toList());
            subscribers.forEach(arg_0 -> InMemFactStore.lambda$null$6((Fact)inMemFact, arg_0));
        });
    }

    public Subscription subscribe(SubscriptionRequestTO request, FactObserver observer) {
        SubscriptionImpl subscription = SubscriptionImpl.on((GenericObserver)observer);
        InMemFollower s = new InMemFollower(request, (SubscriptionImpl<Fact>)subscription);
        this.executorService.submit(() -> {
            AtomicLong ser = new AtomicLong(-1L);
            if (!request.ephemeral()) {
                this.doCatchUp(s, ser);
            }
            InMemFactStore inMemFactStore = this;
            synchronized (inMemFactStore) {
                if (!request.ephemeral()) {
                    this.doCatchUp(s, ser);
                }
                if (request.continuous()) {
                    this.activeFollowers.add(s);
                }
            }
            subscription.notifyCatchup();
            if (!request.continuous()) {
                subscription.notifyComplete();
            }
        });
        return subscription.onClose(s::close);
    }

    private void doCatchUp(InMemFollower s, AtomicLong highwater) {
        new ArrayList<Fact>(this.store.values()).stream().filter(f -> f.serial() > highwater.get() && s.test((Fact)f)).forEachOrdered(f -> {
            highwater.set(f.serial());
            s.accept((Fact)f);
        });
    }

    public synchronized void shutdown() {
        this.executorService.shutdown();
    }

    public synchronized OptionalLong serialOf(UUID l) {
        for (Map.Entry<Long, Fact> e : this.store.entrySet()) {
            if (!l.equals(e.getValue().id())) continue;
            return OptionalLong.of(e.getKey());
        }
        return OptionalLong.empty();
    }

    public Set<String> enumerateNamespaces() {
        return this.store.values().stream().map(Fact::ns).collect(Collectors.toSet());
    }

    public Set<String> enumerateTypes(String ns) {
        return this.store.values().stream().filter(f -> f.ns().equals(ns)).map(Fact::type).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Optional<UUID> latestFactFor(Optional<String> ns, UUID aggId) {
        Fact last = this.store.values().stream().filter(f -> (!ns.isPresent() || f.ns().equals(ns.get())) && f.aggIds().contains(aggId)).reduce(null, (oldId, newId) -> newId);
        return Optional.ofNullable(last).map(Fact::id);
    }

    protected Map<UUID, Optional<UUID>> getStateFor(Optional<String> ns, Collection<UUID> forAggIds) {
        LinkedHashMap<UUID, Optional<UUID>> state = new LinkedHashMap<UUID, Optional<UUID>>();
        forAggIds.forEach(id -> state.put((UUID)id, this.latestFactFor(ns, (UUID)id)));
        return state;
    }

    public synchronized boolean publishIfUnchanged(@NonNull List<? extends Fact> factsToPublish, @NonNull Optional<StateToken> optionalToken) {
        if (factsToPublish == null) {
            throw new NullPointerException("factsToPublish is marked non-null but is null");
        }
        if (optionalToken == null) {
            throw new NullPointerException("optionalToken is marked non-null but is null");
        }
        return super.publishIfUnchanged(factsToPublish, optionalToken);
    }

    public long currentTime() {
        return System.currentTimeMillis();
    }

    private static /* synthetic */ void lambda$null$6(Fact inMemFact, InMemFollower s) {
        s.accept(inMemFact);
    }

    private static /* synthetic */ boolean lambda$null$5(Fact inMemFact, InMemFollower s) {
        return s.test(inMemFact);
    }

    private class InMemFollower
    implements Predicate<Fact>,
    Consumer<Fact>,
    AutoCloseable {
        private final Predicate<Fact> matcher;
        private final SubscriptionImpl<Fact> subscription;

        InMemFollower(SubscriptionRequestTO request, SubscriptionImpl<Fact> subscription) {
            this.subscription = subscription;
            Predicate anyOf = FactSpecMatcher.matchesAnyOf((List)request.specs());
            if (request.startingAfter().isPresent()) {
                AfterPredicate afterPredicate = new AfterPredicate((UUID)request.startingAfter().get());
                this.matcher = f -> afterPredicate.test((Fact)f) && anyOf.test(f);
            } else {
                this.matcher = anyOf;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            InMemFactStore inMemFactStore = InMemFactStore.this;
            synchronized (inMemFactStore) {
                InMemFactStore.this.activeFollowers.remove(this);
            }
        }

        @Override
        public boolean test(Fact f) {
            return this.matcher.test(f);
        }

        @Override
        public void accept(Fact t) {
            this.subscription.notifyElement((Object)t);
        }
    }

    class AfterPredicate
    implements Predicate<Fact> {
        private final Long serAfter;

        AfterPredicate(UUID after) {
            this.serAfter = InMemFactStore.this.factid2ser.getOrDefault(after, -1L);
        }

        @Override
        public boolean test(Fact t) {
            return t.serial() > this.serAfter;
        }
    }
}

