/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.inmem;

import java.util.UUID;
import org.factcast.core.DefaultFact;
import org.factcast.core.Fact;
import org.factcast.core.util.FactCastJson;
import org.factcast.store.inmem.InMemFact;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InMemFactTest {
    @Test
    void testAddMeta() {
        Fact f1 = Fact.of((String)("{\"ns\":\"someNs\",\"id\":\"" + UUID.randomUUID() + "\"}"), (String)"{}");
        InMemFact uut = new InMemFact(21L, f1);
        Assertions.assertEquals((long)21L, (long)uut.serial());
    }

    @Test
    void testAddToExistingMeta() {
        Fact f1 = Fact.of((String)("{\"ns\":\"someNs\",\"id\":\"" + UUID.randomUUID() + "\", \"meta\":{\"foo\":\"bar\"}}"), (String)"{}");
        InMemFact uut = new InMemFact(12L, f1);
        Assertions.assertEquals((long)12L, (long)uut.serial());
        Assertions.assertEquals((Object)"bar", (Object)uut.meta("foo"));
    }

    @Test
    void testReplaceFraudulentSer() {
        Fact f1 = Fact.of((String)("{\"ns\":\"someNs\",\"id\":\"" + UUID.randomUUID() + "\", \"meta\":{\"_ser\":99999}}"), (String)"{}");
        Assertions.assertEquals((long)99999L, (long)f1.serial());
        InMemFact uut = new InMemFact(12L, f1);
        Assertions.assertEquals((long)12L, (long)uut.serial());
    }

    @Test
    public void testToString() throws Exception {
        Fact f = Fact.of((String)("{\"ns\":\"someNs\",\"id\":\"" + UUID.randomUUID() + "\"}"), (String)"{}");
        InMemFact f1 = new InMemFact(32L, f);
        Fact d = (Fact)FactCastJson.readValue(DefaultFact.class, (String)f1.toString());
        Fact fact = Fact.of((String)d.jsonHeader(), (String)d.jsonPayload());
        InMemFact f2 = new InMemFact(fact.serial(), fact);
        Assertions.assertNotSame((Object)f1, (Object)f2);
        Assertions.assertEquals((Object)f1, (Object)f2);
    }
}

