/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.inmem;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.Assertions;
import org.factcast.core.store.FactStore;
import org.factcast.store.inmem.InMemFactStore;
import org.factcast.store.test.AbstractFactStoreTest;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class InMemFactStoreTest
extends AbstractFactStoreTest {
    private InMemFactStore store;

    protected FactStore createStoreToTest() {
        this.store = new InMemFactStore();
        return this.store;
    }

    @Test
    void shouldPublishUnconditionallyIfNoTokenProvided() {
        ArrayList list = new ArrayList();
        InMemFactStore uut = (InMemFactStore)Mockito.spy((Object)this.store);
        boolean publishIfUnchanged = uut.publishIfUnchanged(list, Optional.empty());
        Assertions.assertThat((boolean)publishIfUnchanged).isTrue();
        ((InMemFactStore)Mockito.verify((Object)uut)).publish(list);
    }

    @Nested
    class InMemSpecific {
        InMemSpecific() {
        }

        @Test
        void testDestroy() throws Exception {
            ExecutorService es = (ExecutorService)Mockito.mock(ExecutorService.class);
            InMemFactStore inMemFactStore = new InMemFactStore(es);
            inMemFactStore.shutdown();
            ((ExecutorService)Mockito.verify((Object)es)).shutdown();
        }

        @Test
        public void testInMemFactStoreExecutorServiceNullConstructor() throws Exception {
            org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new InMemFactStore(null));
        }
    }
}

