/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.resource;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryType;

public class ConnectionFactoryConfiguration
implements Serializable {
    private static final long serialVersionUID = 6041948376851715924L;
    public static final String RUNTIME = "{runtime}";
    private String name;
    private String provider;
    private ConnectionFactoryType type = ConnectionFactoryType.XA;
    private String username;
    private String password;
    private String clientId;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Properties factoryProperties = new Properties();

    public ConnectionFactoryConfiguration(String name, String provider) {
        this.name = name;
        this.provider = provider;
    }

    public ConnectionFactoryConfiguration(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ConnectionFactoryType getType() {
        return this.type;
    }

    public void setType(ConnectionFactoryType type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setFactoryProperty(String key, String value) {
        this.factoryProperties.put(key, value);
    }

    public Properties getFactoryProperties() {
        return this.factoryProperties;
    }

    public <T> T getAttribute(Class<T> type, String key) {
        Object value = this.attributes.get(key);
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException("Attribute " + key + " is expected to be of type " + type.getName() + " but is of type " + value.getClass().getName());
        }
        return type.cast(value);
    }

    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

