/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.model.type.ModelObject;

public abstract class PropertyAwareObject
extends ModelObject {
    private Map<String, String> properties = null;

    public void addProperty(String name, String value) {
        this.ensurePropertiesNotNull();
        this.properties.put(name, value);
    }

    public void addProperties(Map<String, String> properties) {
        this.ensurePropertiesNotNull();
        this.properties.putAll(properties);
    }

    public Map<String, String> getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return Collections.emptyMap();
    }

    private void ensurePropertiesNotNull() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }
}

