/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.model;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.binding.jms.model.ActivationSpec;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.HeadersDefinition;
import org.fabric3.api.binding.jms.model.MessageSelection;
import org.fabric3.api.binding.jms.model.OperationPropertiesDefinition;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.model.type.ModelObject;

public class JmsBindingMetadata
extends ModelObject {
    private HeadersDefinition uriHeaders = new HeadersDefinition();
    private HeadersDefinition headers = new HeadersDefinition();
    private String jndiUrl;
    private Destination destination;
    private ActivationSpec activationSpec;
    private ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
    private ResponseDefinition response;
    private MessageSelection uriMessageSelection;
    private MessageSelection messageSelection;
    private CorrelationScheme correlationScheme = CorrelationScheme.MESSAGE_ID;
    private Map<String, OperationPropertiesDefinition> operationProperties = new HashMap<String, OperationPropertiesDefinition>();
    private CacheLevel cacheLevel = CacheLevel.ADMINISTERED_OBJECTS;
    private int minReceivers = 1;
    private int maxReceivers = 1;
    private int idleLimit = 1;
    private int receiveTimeout = 15000;
    private int responseTimeout = 600000;
    private int maxMessagesToProcess = -1;
    private long recoveryInterval = 5000L;
    private boolean durable = false;
    private boolean localDelivery;
    private String subscriptionId;
    private String subscriptionIdPrefix;
    private boolean clientAcknowledge;
    private long backoffPeriod = -1L;

    public ConnectionFactoryDefinition getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactoryDefinition connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public CorrelationScheme getCorrelationScheme() {
        return this.correlationScheme;
    }

    public void setCorrelationScheme(CorrelationScheme correlationScheme) {
        this.correlationScheme = correlationScheme;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getJndiUrl() {
        return this.jndiUrl;
    }

    public void setJndiUrl(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public ResponseDefinition getResponse() {
        return this.response;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public Destination getResponseDestination() {
        if (this.response == null) {
            return null;
        }
        return this.response.getDestination();
    }

    public ConnectionFactoryDefinition getResponseConnectionFactory() {
        if (this.response == null) {
            return null;
        }
        return this.response.getConnectionFactory();
    }

    public HeadersDefinition getHeaders() {
        return this.headers;
    }

    public HeadersDefinition getUriHeaders() {
        return this.uriHeaders;
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public MessageSelection getUriMessageSelection() {
        return this.uriMessageSelection;
    }

    public void setUriMessageSelection(MessageSelection selection) {
        this.uriMessageSelection = selection;
    }

    public MessageSelection getMessageSelection() {
        return this.messageSelection;
    }

    public void setMessageSelection(MessageSelection selection) {
        this.messageSelection = selection;
    }

    public Map<String, OperationPropertiesDefinition> getOperationProperties() {
        return this.operationProperties;
    }

    public void addOperationProperties(String name, OperationPropertiesDefinition definition) {
        this.operationProperties.put(name, definition);
    }

    public boolean isResponse() {
        return this.response != null;
    }

    public CacheLevel getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(CacheLevel cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getMinReceivers() {
        return this.minReceivers;
    }

    public void setMinReceivers(int minReceivers) {
        this.minReceivers = minReceivers;
    }

    public int getMaxReceivers() {
        return this.maxReceivers;
    }

    public void setMaxReceivers(int maxReceivers) {
        this.maxReceivers = maxReceivers;
    }

    public int getIdleLimit() {
        return this.idleLimit;
    }

    public void setIdleLimit(int idleLimit) {
        this.idleLimit = idleLimit;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public int getMaxMessagesToProcess() {
        return this.maxMessagesToProcess;
    }

    public void setMaxMessagesToProcess(int maxMessagesToProcess) {
        this.maxMessagesToProcess = maxMessagesToProcess;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isLocalDelivery() {
        return this.localDelivery;
    }

    public void setLocalDelivery(boolean localDelivery) {
        this.localDelivery = localDelivery;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String id) {
        this.subscriptionId = id;
    }

    public String getSubscriptionIdPrefix() {
        return this.subscriptionIdPrefix;
    }

    public void setSubscriptionIdPrefix(String subscriptionIdPrefix) {
        this.subscriptionIdPrefix = subscriptionIdPrefix;
    }

    public boolean isClientAcknowledge() {
        return this.clientAcknowledge;
    }

    public void setClientAcknowledge(boolean clientAcknowledge) {
        this.clientAcknowledge = clientAcknowledge;
    }

    public long getBackoffPeriod() {
        return this.backoffPeriod;
    }

    public void setBackoffPeriod(long backoffPeriod) {
        this.backoffPeriod = backoffPeriod;
    }

    public JmsBindingMetadata snapshot() {
        JmsBindingMetadata copy = new JmsBindingMetadata();
        copy.correlationScheme = this.correlationScheme;
        copy.jndiUrl = this.jndiUrl;
        copy.destination = this.destination;
        copy.messageSelection = this.messageSelection;
        copy.connectionFactory.setCreate(this.connectionFactory.getCreate());
        copy.connectionFactory.setName(this.connectionFactory.getName());
        copy.connectionFactory.addProperties(this.connectionFactory.getProperties());
        copy.response = this.response;
        copy.headers.setDeliveryMode(this.headers.getDeliveryMode());
        copy.headers.addProperties(this.headers.getProperties());
        copy.headers.setPriority(this.headers.getPriority());
        copy.headers.setTimeToLive(this.headers.getTimeToLive());
        copy.headers.setJmsType(this.headers.getJmsType());
        copy.uriHeaders.setDeliveryMode(this.uriHeaders.getDeliveryMode());
        copy.uriHeaders.addProperties(this.uriHeaders.getProperties());
        copy.uriHeaders.setPriority(this.uriHeaders.getPriority());
        copy.uriHeaders.setTimeToLive(this.uriHeaders.getTimeToLive());
        copy.uriHeaders.setJmsType(this.uriHeaders.getJmsType());
        if (this.operationProperties != null) {
            copy.operationProperties = new HashMap<String, OperationPropertiesDefinition>();
            copy.operationProperties.putAll(this.operationProperties);
        }
        copy.cacheLevel = this.cacheLevel;
        copy.minReceivers = this.minReceivers;
        copy.maxReceivers = this.maxReceivers;
        copy.idleLimit = this.idleLimit;
        copy.receiveTimeout = this.receiveTimeout;
        copy.responseTimeout = this.responseTimeout;
        copy.maxMessagesToProcess = this.maxMessagesToProcess;
        copy.recoveryInterval = this.recoveryInterval;
        copy.durable = this.durable;
        copy.localDelivery = this.localDelivery;
        copy.subscriptionId = this.subscriptionId;
        copy.subscriptionIdPrefix = this.subscriptionIdPrefix;
        copy.activationSpec = this.activationSpec;
        copy.clientAcknowledge = this.clientAcknowledge;
        copy.backoffPeriod = this.backoffPeriod;
        return copy;
    }
}

