/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.builder;

import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.model.type.builder.AbstractBuilder;

public class ResponseDefinitionBuilder
extends AbstractBuilder {
    private ResponseDefinition responseDefinition = new ResponseDefinition();

    public static ResponseDefinitionBuilder newBuilder() {
        return new ResponseDefinitionBuilder();
    }

    private ResponseDefinitionBuilder() {
    }

    public ResponseDefinition build() {
        this.checkState();
        this.freeze();
        if (this.responseDefinition.getDestination() == null) {
            throw new IllegalArgumentException("Response destination not defined for JMS binding");
        }
        return this.responseDefinition;
    }

    public ResponseDefinitionBuilder destination(String name, DestinationType type, CreateOption option) {
        this.checkState();
        Destination definition = new Destination();
        definition.setName(name);
        definition.setType(type);
        definition.setCreate(option);
        this.responseDefinition.setDestination(definition);
        return this;
    }

    public ResponseDefinitionBuilder destination(String name, DestinationType type) {
        this.checkState();
        Destination definition = new Destination();
        definition.setName(name);
        definition.setType(type);
        this.responseDefinition.setDestination(definition);
        return this;
    }

    public ResponseDefinitionBuilder connectionFactoryName(String name) {
        this.checkState();
        this.responseDefinition.getConnectionFactory().setName(name);
        return this;
    }

    public ResponseDefinitionBuilder connectionFactoryCreate(CreateOption option) {
        this.checkState();
        this.responseDefinition.getConnectionFactory().setCreate(option);
        return this;
    }
}

