/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.builder;

import java.net.URI;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.Destination;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBinding;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.MessageSelection;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.model.type.builder.AbstractBuilder;

public class JmsBindingBuilder
extends AbstractBuilder {
    private JmsBinding binding;

    public static JmsBindingBuilder newBuilder() {
        return new JmsBindingBuilder();
    }

    private JmsBindingBuilder() {
        this("jms.binding");
    }

    private JmsBindingBuilder(String name) {
        this.binding = new JmsBinding(name, new JmsBindingMetadata());
    }

    public JmsBinding build() {
        this.checkState();
        this.freeze();
        Destination destination = this.binding.getJmsMetadata().getDestination();
        if (destination == null) {
            throw new IllegalArgumentException("Destination not defined for JMS binding");
        }
        String target = destination.getName();
        URI bindingUri = URI.create("jms://" + target);
        this.binding.setGeneratedTargetUri(bindingUri);
        return this.binding;
    }

    public JmsBindingBuilder cacheLevel(CacheLevel level) {
        this.checkState();
        this.binding.getJmsMetadata().setCacheLevel(level);
        return this;
    }

    public JmsBindingBuilder subscriptionId(String id) {
        this.checkState();
        this.binding.getJmsMetadata().setSubscriptionId(id);
        return this;
    }

    public JmsBindingBuilder subscriptionIdPrefix(String id) {
        this.checkState();
        this.binding.getJmsMetadata().setSubscriptionIdPrefix(id);
        return this;
    }

    public JmsBindingBuilder connectionFactoryName(String name) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().setName(name);
        return this;
    }

    public JmsBindingBuilder connectionFactoryProperty(String name, String value) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().addProperty(name, value);
        return this;
    }

    public JmsBindingBuilder connectionFactoryCreate(CreateOption option) {
        this.checkState();
        this.binding.getJmsMetadata().getConnectionFactory().setCreate(option);
        return this;
    }

    public JmsBindingBuilder destination(String name, DestinationType type, CreateOption option) {
        this.checkState();
        Destination definition = new Destination();
        definition.setName(name);
        definition.setType(type);
        definition.setCreate(option);
        this.binding.getJmsMetadata().setDestination(definition);
        return this;
    }

    public JmsBindingBuilder destination(String name, DestinationType type) {
        this.checkState();
        Destination definition = new Destination();
        definition.setName(name);
        definition.setType(type);
        this.binding.getJmsMetadata().setDestination(definition);
        return this;
    }

    public JmsBindingBuilder correlationScheme(CorrelationScheme scheme) {
        this.checkState();
        this.binding.getJmsMetadata().setCorrelationScheme(scheme);
        return this;
    }

    public JmsBindingBuilder durable(boolean durable) {
        this.checkState();
        this.binding.getJmsMetadata().setDurable(durable);
        return this;
    }

    public JmsBindingBuilder idleLimit(int limit) {
        this.checkState();
        this.binding.getJmsMetadata().setIdleLimit(limit);
        return this;
    }

    public JmsBindingBuilder jndiUrl(String url) {
        this.checkState();
        this.binding.getJmsMetadata().setJndiUrl(url);
        return this;
    }

    public JmsBindingBuilder localDelivery(boolean delivery) {
        this.checkState();
        this.binding.getJmsMetadata().setLocalDelivery(delivery);
        return this;
    }

    public JmsBindingBuilder maxMessages(int max) {
        this.checkState();
        this.binding.getJmsMetadata().setMaxMessagesToProcess(max);
        return this;
    }

    public JmsBindingBuilder maxReceivers(int max) {
        this.checkState();
        this.binding.getJmsMetadata().setMaxReceivers(max);
        return this;
    }

    public JmsBindingBuilder minReceivers(int min) {
        this.checkState();
        this.binding.getJmsMetadata().setMinReceivers(min);
        return this;
    }

    public JmsBindingBuilder clientAcknowledge(boolean ack) {
        this.checkState();
        this.binding.getJmsMetadata().setClientAcknowledge(ack);
        return this;
    }

    public JmsBindingBuilder receiveTimeout(int timeout) {
        this.checkState();
        this.binding.getJmsMetadata().setReceiveTimeout(timeout);
        return this;
    }

    public JmsBindingBuilder selector(String selector) {
        this.checkState();
        this.binding.getJmsMetadata().setMessageSelection(new MessageSelection(selector));
        return this;
    }

    public JmsBindingBuilder recoveryInterval(long interval) {
        this.checkState();
        this.binding.getJmsMetadata().setRecoveryInterval(interval);
        return this;
    }

    public JmsBindingBuilder response(ResponseDefinition definition) {
        this.checkState();
        this.binding.getJmsMetadata().setResponse(definition);
        return this;
    }

    public JmsBindingBuilder responseTimeout(int timeout) {
        this.checkState();
        this.binding.getJmsMetadata().setResponseTimeout(timeout);
        return this;
    }

    public JmsBindingBuilder uriSelector(String selector) {
        this.checkState();
        this.binding.getJmsMetadata().setUriMessageSelection(new MessageSelection(selector));
        return this;
    }

    public JmsBindingBuilder backoffPeriod(long period) {
        this.checkState();
        this.binding.getJmsMetadata().setBackoffPeriod(period);
        return this;
    }
}

