/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.api.binding.jms.builder;

import org.fabric3.api.binding.jms.resource.ConnectionFactoryConfiguration;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryResource;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryType;
import org.fabric3.api.model.type.builder.AbstractBuilder;

public class ConnectionFactoryResourceBuilder
extends AbstractBuilder {
    private ConnectionFactoryResource definition;

    public static ConnectionFactoryResourceBuilder newBuilder(String name) {
        return new ConnectionFactoryResourceBuilder(name);
    }

    private ConnectionFactoryResourceBuilder(String name) {
        this.definition = new ConnectionFactoryResource(new ConnectionFactoryConfiguration(name));
    }

    public ConnectionFactoryResourceBuilder property(String key, String value) {
        this.checkState();
        this.definition.getConfiguration().setFactoryProperty(key, value);
        return this;
    }

    public ConnectionFactoryResourceBuilder clientId(String clientId) {
        this.checkState();
        this.definition.getConfiguration().setClientId(clientId);
        return this;
    }

    public ConnectionFactoryResourceBuilder attribute(String key, Object value) {
        this.checkState();
        this.definition.getConfiguration().addAttribute(key, value);
        return this;
    }

    public ConnectionFactoryResourceBuilder provider(String provider) {
        this.checkState();
        this.definition.getConfiguration().setProvider(provider);
        return this;
    }

    public ConnectionFactoryResourceBuilder type(ConnectionFactoryType type) {
        this.checkState();
        this.definition.getConfiguration().setType(type);
        return this;
    }

    public ConnectionFactoryResourceBuilder username(String username) {
        this.checkState();
        this.definition.getConfiguration().setUsername(username);
        return this;
    }

    public ConnectionFactoryResourceBuilder password(String password) {
        this.checkState();
        this.definition.getConfiguration().setPassword(password);
        return this;
    }

    public ConnectionFactoryResource build() {
        this.checkState();
        this.freeze();
        return this.definition;
    }
}

