/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.util;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.host.Fabric3Exception;

public final class ClassLoading {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();

    public static Class<?> loadClass(ClassLoader cl, String className) {
        Class<?> clazz = PRIMITIVES.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
        return clazz;
    }

    public static <T> T instantiate(Class<T> type, ClassLoader cl, String className) {
        try {
            return type.cast(ClassLoading.loadClass(cl, className).newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private ClassLoading() {
    }

    static {
        PRIMITIVES.put("boolean", Boolean.TYPE);
        PRIMITIVES.put("byte", Byte.TYPE);
        PRIMITIVES.put("short", Short.TYPE);
        PRIMITIVES.put("int", Integer.TYPE);
        PRIMITIVES.put("long", Long.TYPE);
        PRIMITIVES.put("float", Float.TYPE);
        PRIMITIVES.put("double", Double.TYPE);
        PRIMITIVES.put("void", Void.TYPE);
    }
}

