/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.fabric3.api.Role;
import org.fabric3.api.SecuritySubject;

public class BasicSecuritySubject
implements SecuritySubject,
Principal {
    private String username;
    private String password;
    private Set<Role> roles;
    private Subject jaasSubject;

    public BasicSecuritySubject(String username, String password, Set<Role> roles) {
        this.username = username;
        this.password = password;
        this.roles = roles;
        HashSet<Role> principals = new HashSet<Role>(roles);
        principals.add((Role)this);
        this.jaasSubject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String name) {
        return this.roles.contains(new Role(name));
    }

    public <T> T getDelegate(Class<T> type) {
        if (!BasicSecuritySubject.class.equals(type)) {
            throw new IllegalArgumentException("Unknown delegate type: " + type);
        }
        return type.cast(this);
    }

    public Subject getJaasSubject() {
        return this.jaasSubject;
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public String toString() {
        return this.username;
    }
}

