/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.version;

import java.io.Serializable;
import org.fabric3.api.host.Version;

public abstract class Versionable
implements Serializable {
    private static final long serialVersionUID = -1603295817528974598L;
    private static final Version NON_SPECIFIED = new Version(0, 0, 0);
    protected Version minVersion = NON_SPECIFIED;
    protected Version maxVersion;
    protected boolean minInclusive = true;
    protected boolean maxInclusive = true;

    public Versionable(Version minVersion, boolean minInclusive, Version maxVersion, boolean maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public Versionable(Version version, boolean minInclusive) {
        this.minVersion = version;
        this.minInclusive = minInclusive;
    }

    public Versionable(Version version) {
        this.minVersion = version;
    }

    public Versionable() {
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(Version minVersion) {
        this.minVersion = minVersion;
    }

    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(Version maxVersion) {
        this.maxVersion = maxVersion;
    }

    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    protected boolean matches(Version other) {
        if (this.minVersion != null && (this.minInclusive ? this.minVersion.compareTo((Object)other) > 0 : this.minVersion.compareTo((Object)other) >= 0)) {
            return false;
        }
        return this.maxVersion == null || !(this.maxInclusive ? this.maxVersion.compareTo((Object)other) < 0 : this.maxVersion.compareTo((Object)other) <= 0);
    }
}

