/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalScaArtifact;

public class LogicalInvocable
extends LogicalScaArtifact<LogicalComponent<?>> {
    private static final long serialVersionUID = 4182922230894994435L;
    protected ServiceContract serviceContract;
    protected List<LogicalOperation> operations;
    protected List<LogicalOperation> callbackOperations;
    private URI uri;

    protected LogicalInvocable(URI uri, ServiceContract contract, LogicalComponent<?> parent) {
        super(parent);
        this.uri = uri;
        this.createOperations(contract);
        this.serviceContract = contract;
    }

    public URI getUri() {
        return this.uri;
    }

    public List<LogicalOperation> getOperations() {
        return this.operations;
    }

    public List<LogicalOperation> getCallbackOperations() {
        return this.callbackOperations;
    }

    public ServiceContract getServiceContract() {
        return this.serviceContract;
    }

    public void setServiceContract(ServiceContract serviceContract) {
        this.serviceContract = serviceContract;
        this.createOperations(serviceContract);
    }

    protected final void createOperations(ServiceContract contract) {
        this.operations = new ArrayList<LogicalOperation>();
        this.callbackOperations = new ArrayList<LogicalOperation>();
        if (contract != null) {
            this.operations.addAll(contract.getOperations().stream().map(operation -> new LogicalOperation((Operation)operation, this)).collect(Collectors.toList()));
            ServiceContract callbackContract = contract.getCallbackContract();
            if (callbackContract != null) {
                for (Operation operation2 : callbackContract.getOperations()) {
                    this.callbackOperations.add(new LogicalOperation(operation2, this));
                }
            }
        }
    }
}

