/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.api.host.stream.Source;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Resource;

public class Contribution
implements Serializable {
    private static final long serialVersionUID = 2511879480122631196L;
    private URI uri;
    private transient Source source;
    private ContributionState state = ContributionState.STORED;
    private URL location;
    private long timestamp;
    private String contentType;
    private ContributionManifest manifest = new ContributionManifest();
    private transient List<Resource> resources = new ArrayList<Resource>();
    private transient Map<Object, Object> metadata = new HashMap<Object, Object>();
    private List<ContributionWire<?, ?>> wires = new ArrayList();
    private List<URI> resolvedExtensionProviders = new ArrayList<URI>();
    private List<URL> additionalLocations = new ArrayList<URL>();
    private int deployCounter;

    public Contribution(URI uri) {
        this.uri = uri;
    }

    public Contribution(URI uri, Source source, URL location, long timestamp, String contentType) {
        this.uri = uri;
        this.source = source;
        this.location = location;
        this.timestamp = timestamp;
        this.contentType = contentType;
    }

    public URI getUri() {
        return this.uri;
    }

    public ContributionState getState() {
        return this.state;
    }

    public void install() {
        if (this.state != ContributionState.STORED) {
            throw new IllegalStateException("Contribution must be in STORED state: " + (Object)((Object)this.state));
        }
        this.state = ContributionState.INSTALLED;
    }

    public void uninstall() {
        if (this.state != ContributionState.INSTALLED) {
            throw new IllegalStateException("Contribution must be in INSTALLED state: " + (Object)((Object)this.state));
        }
        this.state = ContributionState.STORED;
    }

    public void deploy() {
        if (this.state != ContributionState.INSTALLED && this.state != ContributionState.DEPLOYED) {
            throw new IllegalStateException("Contribution must be in INSTALLED or DEPLOYED state: " + (Object)((Object)this.state));
        }
        this.state = ContributionState.DEPLOYED;
        ++this.deployCounter;
    }

    public void undeploy() {
        if (this.state != ContributionState.DEPLOYED) {
            throw new IllegalStateException("Contribution must be in DEPLOYED state: " + (Object)((Object)this.state));
        }
        --this.deployCounter;
        if (this.deployCounter == 0) {
            this.state = ContributionState.INSTALLED;
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public void overrideLocation(URL location) {
        this.location = location;
    }

    public List<URL> getAdditionalLocations() {
        return this.additionalLocations;
    }

    public void addAdditionalLocation(URL location) {
        this.additionalLocations.add(location);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Source getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ContributionManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(ContributionManifest manifest) {
        this.manifest = manifest;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void addWire(ContributionWire<?, ?> wire) {
        this.wires.add(wire);
    }

    public List<ContributionWire<?, ?>> getWires() {
        return this.wires;
    }

    public void addResolvedExtensionProvider(URI uri) {
        this.resolvedExtensionProviders.add(uri);
    }

    public List<URI> getResolvedExtensionProviders() {
        return this.resolvedExtensionProviders;
    }

    public void addMetaData(Object key, Object value) {
        this.metadata.put(key, value);
    }

    public void removeMetaData(Object key) {
        this.metadata.remove(key);
    }

    public <T> T getMetaData(Class<T> type, Object key) {
        return type.cast(this.metadata.get(key));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contribution that = (Contribution)o;
        return !(this.uri == null ? that.uri != null : !this.uri.equals(that.uri));
    }
}

