/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.container.invocation;

import org.fabric3.spi.container.invocation.Fabric3Thread;
import org.fabric3.spi.container.invocation.WorkContext;

public final class WorkContextCache {
    private static final ThreadLocal<WorkContext> CONTEXT = new ThreadLocal();

    private WorkContextCache() {
    }

    public static WorkContext getThreadWorkContext() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Fabric3Thread) {
            Fabric3Thread fabric3Thread = (Fabric3Thread)thread;
            WorkContext workContext = fabric3Thread.getWorkContext();
            if (workContext == null) {
                workContext = new WorkContext();
                fabric3Thread.setWorkContext(workContext);
            }
            return workContext;
        }
        WorkContext workContext = CONTEXT.get();
        if (workContext == null) {
            workContext = new WorkContext();
            CONTEXT.set(workContext);
        }
        return workContext;
    }

    public static WorkContext getAndResetThreadWorkContext() {
        WorkContext workContext = WorkContextCache.getThreadWorkContext();
        workContext.reset();
        return workContext;
    }
}

