/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.container.invocation;

import org.fabric3.spi.container.invocation.Fabric3Thread;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageImpl;

public class MessageCache {
    private static final ThreadLocal<Message> CONTEXT = new ThreadLocal();

    private MessageCache() {
    }

    public static Message getMessage() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Fabric3Thread) {
            Fabric3Thread fabric3Thread = (Fabric3Thread)thread;
            Message message = fabric3Thread.getMessage();
            if (message == null) {
                message = new MessageImpl();
                fabric3Thread.setMessage(message);
            }
            return message;
        }
        Message message = CONTEXT.get();
        if (message == null) {
            message = new MessageImpl();
            CONTEXT.set(message);
        }
        return message;
    }

    public static Message getAndResetMessage() {
        Message message = MessageCache.getMessage();
        message.reset();
        return message;
    }
}

